/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import com.github.fge.lambdas.Throwing;
import jakarta.mail.Flags;
import java.time.Clock;
import java.util.EnumSet;
import java.util.function.Function;
import org.apache.james.events.EventBus;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.openjpa.OpenJPAMessageFactory;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageFactory;
import org.apache.james.mailbox.store.MessageStorer;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import reactor.core.publisher.Mono;

public class OpenJPAMessageManager
extends StoreMessageManager {
    private final MailboxSessionMapperFactory mapperFactory;
    private final StoreRightManager storeRightManager;
    private final Mailbox mailbox;

    public OpenJPAMessageManager(MailboxSessionMapperFactory mapperFactory, MessageSearchIndex index, EventBus eventBus, MailboxPathLocker locker, Mailbox mailbox, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MessageId.Factory messageIdFactory, BatchSizes batchSizes, StoreRightManager storeRightManager, ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm, Clock clock) {
        super(StoreMailboxManager.DEFAULT_NO_MESSAGE_CAPABILITIES, mapperFactory, index, eventBus, locker, mailbox, quotaManager, quotaRootResolver, batchSizes, storeRightManager, PreDeletionHooks.NO_PRE_DELETION_HOOK, (MessageStorer)new MessageStorer.WithoutAttachment(mapperFactory, messageIdFactory, (MessageFactory)new OpenJPAMessageFactory(), threadIdGuessingAlgorithm, clock));
        this.storeRightManager = storeRightManager;
        this.mapperFactory = mapperFactory;
        this.mailbox = mailbox;
    }

    public Flags getPermanentFlags(MailboxSession session) {
        Flags flags = super.getPermanentFlags(session);
        flags.add(Flags.Flag.USER);
        return flags;
    }

    public Mono<MessageManager.MailboxMetaData> getMetaDataReactive(MessageManager.MailboxMetaData.RecentMode recentMode, MailboxSession mailboxSession, EnumSet<MessageManager.MailboxMetaData.Item> items) throws MailboxException {
        MailboxACL resolvedAcl = this.getResolvedAcl(mailboxSession);
        if (!this.storeRightManager.hasRight(this.mailbox, MailboxACL.Right.Read, mailboxSession)) {
            return Mono.just((Object)MessageManager.MailboxMetaData.sensibleInformationFree((MailboxACL)resolvedAcl, (UidValidity)this.getMailboxEntity().getUidValidity(), (boolean)this.isWriteable(mailboxSession)));
        }
        Flags permanentFlags = this.getPermanentFlags(mailboxSession);
        UidValidity uidValidity = this.getMailboxEntity().getUidValidity();
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        return messageMapper.executeReactive(this.nextUid(messageMapper, items).flatMap(nextUid -> this.highestModSeq(messageMapper, items).flatMap(highestModSeq -> this.firstUnseen(messageMapper, items).flatMap((Function)Throwing.function(firstUnseen -> this.recent(recentMode, mailboxSession).flatMap(recents -> this.mailboxCounters(messageMapper, items).map(counters -> new MessageManager.MailboxMetaData(recents, permanentFlags, uidValidity, nextUid, highestModSeq, counters.getCount(), counters.getUnseen(), (MessageUid)firstUnseen.orElse(null), this.isWriteable(mailboxSession), resolvedAcl))))))));
    }
}

