/*
 * Decompiled with CFR 0.152.
 */
package reactor.extra.processor;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.extra.processor.EventLoopProcessor;
import reactor.extra.processor.RingBuffer;
import reactor.extra.processor.WaitStrategy;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;

@Deprecated
public final class TopicProcessor<E>
extends EventLoopProcessor<E> {
    final RingBuffer.Reader barrier;
    final RingBuffer.Sequence minimum = RingBuffer.newSequence(-1L);

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static <E> TopicProcessor<E> create() {
        return TopicProcessor.builder().build();
    }

    public static <E> TopicProcessor<E> create(String name, int bufferSize) {
        return TopicProcessor.builder().name(name).bufferSize(bufferSize).build();
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize) {
        return TopicProcessor.builder().share(true).name(name).bufferSize(bufferSize).build();
    }

    TopicProcessor(@Nullable ThreadFactory threadFactory, @Nullable ExecutorService executor, ExecutorService requestTaskExecutor, int bufferSize, WaitStrategy waitStrategy, boolean shared, boolean autoCancel, @Nullable Supplier<E> signalSupplier) {
        super(bufferSize, threadFactory, executor, requestTaskExecutor, autoCancel, shared, () -> {
            EventLoopProcessor.Slot signal = new EventLoopProcessor.Slot();
            if (signalSupplier != null) {
                signal.value = signalSupplier.get();
            }
            return signal;
        }, waitStrategy);
        this.barrier = this.ringBuffer.newReader();
    }

    public void subscribe(CoreSubscriber<? super E> actual) {
        Objects.requireNonNull(actual, "subscribe");
        if (!this.alive()) {
            TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.minimum).subscribe(actual);
            return;
        }
        RingBuffer.Sequence pendingRequest = RingBuffer.newSequence(0L);
        TopicInner<? super E> signalProcessor = new TopicInner<E>(this, pendingRequest, actual);
        if (this.incrementSubscribers()) {
            signalProcessor.sequence.set(this.minimum.getAsLong());
            this.ringBuffer.addGatingSequence(signalProcessor.sequence);
        } else {
            signalProcessor.sequence.set(this.ringBuffer.getCursor());
            this.ringBuffer.addGatingSequence(signalProcessor.sequence);
        }
        try {
            this.executor.execute(signalProcessor);
        }
        catch (Throwable t) {
            this.ringBuffer.removeGatingSequence(signalProcessor.sequence);
            this.decrementSubscribers();
            if (!this.alive() && RejectedExecutionException.class.isAssignableFrom(t.getClass())) {
                TopicProcessor.coldSource(this.ringBuffer, t, this.error, this.minimum).subscribe(actual);
            }
            Operators.error(actual, (Throwable)t);
        }
    }

    @Override
    public Flux<E> drain() {
        return TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.minimum);
    }

    @Override
    protected void doError(Throwable t) {
        this.barrier.signal();
    }

    @Override
    protected void doComplete() {
        this.barrier.signal();
    }

    @Override
    public long getPending() {
        return this.ringBuffer.getPending();
    }

    @Override
    protected void requestTask(Subscription s) {
        this.minimum.set(this.ringBuffer.getCursor());
        this.ringBuffer.addGatingSequence(this.minimum);
        this.requestTaskExecutor.execute(TopicProcessor.createRequestTask(s, this, this.minimum::set, () -> SUBSCRIBER_COUNT.get(this) == 0 ? this.minimum.getAsLong() : this.ringBuffer.getMinimumGatingSequence(this.minimum)));
    }

    @Override
    public void run() {
        if (!this.alive() && SUBSCRIBER_COUNT.get(this) == 0) {
            WaitStrategy.alert();
        }
    }

    static final class TopicInner<T>
    implements Runnable,
    Subscription,
    Scannable {
        final AtomicBoolean running = new AtomicBoolean(true);
        final RingBuffer.Sequence sequence = RingBuffer.newSequence(-1L);
        final TopicProcessor<T> processor;
        final RingBuffer.Sequence pendingRequest;
        final CoreSubscriber<? super T> subscriber;
        final Runnable waiter = new Runnable(){

            @Override
            public void run() {
                if (!running.get() || processor.isTerminated()) {
                    WaitStrategy.alert();
                }
            }
        };

        TopicInner(TopicProcessor<T> processor, RingBuffer.Sequence pendingRequest, CoreSubscriber<? super T> subscriber) {
            this.processor = processor;
            this.pendingRequest = pendingRequest;
            this.subscriber = subscriber;
        }

        void halt() {
            this.running.set(false);
            this.processor.barrier.alert();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.currentThread().setContextClassLoader(this.processor.contextClassLoader);
                this.subscriber.onSubscribe((Subscription)this);
                if (!EventLoopProcessor.waitRequestOrTerminalEvent(this.pendingRequest, this.processor.barrier, this.running, this.sequence, this.waiter)) {
                    if (!this.running.get()) {
                        return;
                    }
                    if (this.processor.terminated == 1) {
                        if (this.processor.ringBuffer.getAsLong() == -1L) {
                            if (this.processor.error != null) {
                                this.subscriber.onError(this.processor.error);
                                return;
                            }
                            this.subscriber.onComplete();
                            return;
                        }
                    } else if (this.processor.terminated == 2) {
                        return;
                    }
                }
                long nextSequence = this.sequence.getAsLong() + 1L;
                boolean unbounded = this.pendingRequest.getAsLong() == Long.MAX_VALUE;
                while (true) {
                    try {
                        while (true) {
                            long availableSequence = this.processor.barrier.waitFor(nextSequence, this.waiter);
                            while (nextSequence <= availableSequence) {
                                EventLoopProcessor.Slot event = (EventLoopProcessor.Slot)this.processor.ringBuffer.get(nextSequence);
                                while (!unbounded && EventLoopProcessor.getAndSub(this.pendingRequest, 1L) == 0L) {
                                    if (!this.running.get() || this.processor.isTerminated()) {
                                        WaitStrategy.alert();
                                    }
                                    LockSupport.parkNanos(1L);
                                }
                                this.subscriber.onNext(event.value);
                                ++nextSequence;
                            }
                            this.sequence.set(availableSequence);
                            if (Operators.emptySubscription() == this.processor.upstreamSubscription) continue;
                            this.processor.readWait.signalAllWhenBlocking();
                        }
                    }
                    catch (Throwable ex) {
                        block26: {
                            block25: {
                                block30: {
                                    block27: {
                                        block29: {
                                            block28: {
                                                if (!WaitStrategy.isAlert(ex) && !Exceptions.isCancel((Throwable)ex)) break block25;
                                                if (!this.running.get()) break block26;
                                                if (this.processor.terminated != 1) break block27;
                                                if (this.processor.error == null) break block28;
                                                this.subscriber.onError(this.processor.error);
                                                break block26;
                                            }
                                            if (nextSequence <= this.processor.ringBuffer.getAsLong()) break block29;
                                            this.subscriber.onComplete();
                                            break block26;
                                        }
                                        LockSupport.parkNanos(1L);
                                        break block30;
                                    }
                                    if (this.processor.terminated == 2) break block26;
                                }
                                this.processor.barrier.clearAlert();
                                continue;
                                break block26;
                            }
                            throw Exceptions.propagate((Throwable)ex);
                        }
                        this.processor.ringBuffer.removeGatingSequence(this.sequence);
                        this.processor.decrementSubscribers();
                        this.running.set(false);
                        this.processor.readWait.signalAllWhenBlocking();
                    }
                    break;
                }
            }
            finally {
                this.processor.ringBuffer.removeGatingSequence(this.sequence);
                this.processor.decrementSubscribers();
                this.running.set(false);
                this.processor.readWait.signalAllWhenBlocking();
            }
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.processor;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.subscriber;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return Integer.MAX_VALUE;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.processor.isTerminated();
            }
            if (key == Scannable.Attr.CANCELLED) {
                return !this.running.get();
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.pendingRequest.getAsLong();
            }
            if (key == Scannable.Attr.LARGE_BUFFERED) {
                return this.processor.ringBuffer.getCursor() - this.sequence.getAsLong();
            }
            if (key == Scannable.Attr.BUFFERED) {
                long realBuffered = this.processor.ringBuffer.getCursor() - this.sequence.getAsLong();
                if (realBuffered <= Integer.MAX_VALUE) {
                    return (int)realBuffered;
                }
                return Integer.MIN_VALUE;
            }
            return null;
        }

        public void request(long n) {
            if (!Operators.validate((long)n) || !this.running.get()) {
                return;
            }
            EventLoopProcessor.addCap(this.pendingRequest, n);
        }

        public void cancel() {
            this.halt();
        }
    }

    public static final class Builder<T> {
        String name;
        ExecutorService executor;
        ExecutorService requestTaskExecutor;
        int bufferSize = Queues.SMALL_BUFFER_SIZE;
        WaitStrategy waitStrategy;
        boolean share = false;
        boolean autoCancel = true;
        Supplier<T> signalSupplier;

        Builder() {
        }

        public Builder<T> name(@Nullable String name) {
            if (this.executor != null) {
                throw new IllegalArgumentException("Executor service is configured, name will not be used.");
            }
            this.name = name;
            return this;
        }

        public Builder<T> bufferSize(int bufferSize) {
            if (!Queues.isPowerOfTwo((int)bufferSize)) {
                throw new IllegalArgumentException("bufferSize must be a power of 2 : " + bufferSize);
            }
            if (bufferSize < 1) {
                throw new IllegalArgumentException("bufferSize must be strictly positive, was: " + bufferSize);
            }
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder<T> waitStrategy(@Nullable WaitStrategy waitStrategy) {
            this.waitStrategy = waitStrategy;
            return this;
        }

        public Builder<T> autoCancel(boolean autoCancel) {
            this.autoCancel = autoCancel;
            return this;
        }

        public Builder<T> executor(@Nullable ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder<T> requestTaskExecutor(@Nullable ExecutorService requestTaskExecutor) {
            this.requestTaskExecutor = requestTaskExecutor;
            return this;
        }

        public Builder<T> share(boolean share) {
            this.share = share;
            return this;
        }

        public Builder<T> signalSupplier(@Nullable Supplier<T> signalSupplier) {
            this.signalSupplier = signalSupplier;
            return this;
        }

        public TopicProcessor<T> build() {
            this.name = this.name != null ? this.name : TopicProcessor.class.getSimpleName();
            this.waitStrategy = this.waitStrategy != null ? this.waitStrategy : WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS);
            EventLoopProcessor.EventLoopFactory threadFactory = this.executor != null ? null : new EventLoopProcessor.EventLoopFactory(this.name, this.autoCancel);
            ExecutorService requestTaskExecutor = this.requestTaskExecutor != null ? this.requestTaskExecutor : EventLoopProcessor.defaultRequestTaskExecutor(EventLoopProcessor.defaultName(threadFactory, TopicProcessor.class));
            return new TopicProcessor<T>(threadFactory, this.executor, requestTaskExecutor, this.bufferSize, this.waitStrategy, this.share, this.autoCancel, this.signalSupplier);
        }
    }
}

