/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HeaderSkippingOutputStream
extends FilterOutputStream {
    private final byte[] skipTo = "\r\n\r\n".getBytes();
    private boolean inHeaders = true;
    private int pos = 0;

    public HeaderSkippingOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.inHeaders) {
            for (int i = off; i < off + len; ++i) {
                if (b[i] == this.skipTo[this.pos]) {
                    ++this.pos;
                    if (this.pos != this.skipTo.length) continue;
                    this.inHeaders = false;
                    if (len - i - 1 > 0) {
                        this.out.write(b, i + 1, len - i - 1);
                    }
                    break;
                }
                this.pos = 0;
            }
        } else {
            this.out.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.inHeaders) {
            if (this.skipTo[this.pos] == b) {
                ++this.pos;
                if (this.pos == this.skipTo.length) {
                    this.inHeaders = false;
                }
            } else {
                this.pos = 0;
            }
        } else {
            this.out.write(b);
        }
    }
}

