/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.spamassassin;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.FileNotFoundException;
import javax.inject.Singleton;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.mailbox.spamassassin.SpamAssassinConfiguration;
import org.apache.james.modules.spamassassin.SpamAssassinConfigurationLoader;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpamAssassinListenerModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpamAssassinListenerModule.class);
    public static final String SPAMASSASSIN_CONFIGURATION_NAME = "spamassassin";

    protected void configure() {
    }

    @Provides
    @Singleton
    private SpamAssassinConfiguration getSpamAssassinConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration(SPAMASSASSIN_CONFIGURATION_NAME);
            return SpamAssassinConfigurationLoader.fromProperties(configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find spamassassin configuration file. Disabling this service.");
            return SpamAssassinConfigurationLoader.disable();
        }
    }
}

