/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum AccessLogMessageType {
    ASSURANCE_COMPLETE("ASSURANCE-COMPLETE"),
    CLIENT_CERTIFICATE("CLIENT-CERTIFICATE"),
    CONNECT("CONNECT"),
    DISCONNECT("DISCONNECT"),
    ENTRY("ENTRY"),
    ENTRY_REBALANCING_REQUEST("ENTRY-REBALANCING-REQUEST"),
    ENTRY_REBALANCING_RESULT("ENTRY-REBALANCING-RESULT"),
    FORWARD("FORWARD"),
    FORWARD_FAILED("FORWARD-FAILED"),
    INTERMEDIATE_RESPONSE("INTERMEDIATE-RESPONSE"),
    REFERENCE("REFERENCE"),
    REQUEST("REQUEST"),
    RESULT("RESULT"),
    SECURITY_NEGOTIATION("SECURITY-NEGOTIATION");

    @NotNull
    private final String logIdentifier;

    private AccessLogMessageType(String logIdentifier) {
        this.logIdentifier = logIdentifier;
    }

    @NotNull
    public String getLogIdentifier() {
        return this.logIdentifier;
    }

    @Nullable
    public static AccessLogMessageType forName(@NotNull String logIdentifier) {
        for (AccessLogMessageType t : AccessLogMessageType.values()) {
            if (!t.logIdentifier.equals(logIdentifier)) continue;
            return t;
        }
        return null;
    }
}

