/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class HistoryUpdateResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=695");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=697");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=696");
    private final StatusCode statusCode;
    private final StatusCode[] operationResults;
    private final DiagnosticInfo[] diagnosticInfos;

    public HistoryUpdateResult(StatusCode statusCode, StatusCode[] operationResults, DiagnosticInfo[] diagnosticInfos) {
        this.statusCode = statusCode;
        this.operationResults = operationResults;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public StatusCode[] getOperationResults() {
        return this.operationResults;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    protected HistoryUpdateResult(HistoryUpdateResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((HistoryUpdateResultBuilder)b).statusCode;
        this.operationResults = ((HistoryUpdateResultBuilder)b).operationResults;
        this.diagnosticInfos = ((HistoryUpdateResultBuilder)b).diagnosticInfos;
    }

    public static HistoryUpdateResultBuilder<?, ?> builder() {
        return new HistoryUpdateResultBuilderImpl();
    }

    public HistoryUpdateResultBuilder<?, ?> toBuilder() {
        return new HistoryUpdateResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryUpdateResult)) {
            return false;
        }
        HistoryUpdateResult other = (HistoryUpdateResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOperationResults(), other.getOperationResults())) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticInfos(), other.getDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryUpdateResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOperationResults());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "HistoryUpdateResult(statusCode=" + this.getStatusCode() + ", operationResults=" + Arrays.deepToString(this.getOperationResults()) + ", diagnosticInfos=" + Arrays.deepToString(this.getDiagnosticInfos()) + ")";
    }

    private static final class HistoryUpdateResultBuilderImpl
    extends HistoryUpdateResultBuilder<HistoryUpdateResult, HistoryUpdateResultBuilderImpl> {
        private HistoryUpdateResultBuilderImpl() {
        }

        @Override
        protected HistoryUpdateResultBuilderImpl self() {
            return this;
        }

        @Override
        public HistoryUpdateResult build() {
            return new HistoryUpdateResult(this);
        }
    }

    public static abstract class HistoryUpdateResultBuilder<C extends HistoryUpdateResult, B extends HistoryUpdateResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private StatusCode[] operationResults;
        private DiagnosticInfo[] diagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HistoryUpdateResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(HistoryUpdateResult instance, HistoryUpdateResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.operationResults(instance.operationResults);
            b.diagnosticInfos(instance.diagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B operationResults(StatusCode[] operationResults) {
            this.operationResults = operationResults;
            return (B)this.self();
        }

        public B diagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
            this.diagnosticInfos = diagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HistoryUpdateResult.HistoryUpdateResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", operationResults=" + Arrays.deepToString(this.operationResults) + ", diagnosticInfos=" + Arrays.deepToString(this.diagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryUpdateResult> {
        @Override
        public Class<HistoryUpdateResult> getType() {
            return HistoryUpdateResult.class;
        }

        @Override
        public HistoryUpdateResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            StatusCode[] operationResults = decoder.readStatusCodeArray("OperationResults");
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            return new HistoryUpdateResult(statusCode, operationResults, diagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryUpdateResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeStatusCodeArray("OperationResults", value.getOperationResults());
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
        }
    }
}

