/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.runtime;

import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.concurrent.Executor;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

@Recorder
public class AmazonClientBuilderRecorder {
    public RuntimeValue<AwsClientBuilder> createSyncBuilder(RuntimeValue<AwsSyncClientBuilder<?, ?>> builder, RuntimeValue<SdkHttpClient.Builder> transport) {
        if (transport != null) {
            ((AwsSyncClientBuilder)builder.getValue()).httpClientBuilder((SdkHttpClient.Builder)transport.getValue());
        }
        return new RuntimeValue((Object)((AwsClientBuilder)builder.getValue()));
    }

    public RuntimeValue<AwsClientBuilder> createAsyncBuilder(RuntimeValue<AwsAsyncClientBuilder<?, ?>> builder, RuntimeValue<SdkAsyncHttpClient.Builder> transport, LaunchMode launchMode, Executor executor, RuntimeValue<AsyncHttpClientConfig> config) {
        if (transport != null) {
            ((AwsAsyncClientBuilder)builder.getValue()).httpClientBuilder((SdkAsyncHttpClient.Builder)transport.getValue());
        }
        Executor configExecutor = !((AsyncHttpClientConfig)config.getValue()).advanced().useFutureCompletionThreadPool() ? Runnable::run : executor;
        if (launchMode != LaunchMode.NORMAL) {
            configExecutor = new ClassLoaderExecutorWrapper(executor);
        }
        Executor futureCompletionExecutor = configExecutor;
        ((AwsAsyncClientBuilder)builder.getValue()).asyncConfiguration(asyncConfigBuilder -> asyncConfigBuilder.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, (Object)futureCompletionExecutor));
        return new RuntimeValue((Object)((AwsClientBuilder)builder.getValue()));
    }

    public RuntimeValue<SdkPresigner.Builder> createPresignerBuilder() {
        throw new UnsupportedOperationException();
    }

    private static final class ClassLoaderExecutorWrapper
    implements Executor {
        private Executor executor;
        private ClassLoader contextClassLoader;

        private ClassLoaderExecutorWrapper(Executor executor) {
            this.executor = executor;
            this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public void execute(Runnable command) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.contextClassLoader);
                this.executor.execute(command);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

