/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.ConfigurationTemplate;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesResponse;

public class DescribeConfigurationTemplatesIterable
implements SdkIterable<DescribeConfigurationTemplatesResponse> {
    private final CloudWatchLogsClient client;
    private final DescribeConfigurationTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeConfigurationTemplatesIterable(CloudWatchLogsClient client, DescribeConfigurationTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeConfigurationTemplatesResponseFetcher();
    }

    public Iterator<DescribeConfigurationTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationTemplate> configurationTemplates() {
        Function<DescribeConfigurationTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationTemplates() != null) {
                return response.configurationTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeConfigurationTemplatesResponseFetcher
    implements SyncPageFetcher<DescribeConfigurationTemplatesResponse> {
        private DescribeConfigurationTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigurationTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeConfigurationTemplatesResponse nextPage(DescribeConfigurationTemplatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigurationTemplatesIterable.this.client.describeConfigurationTemplates(DescribeConfigurationTemplatesIterable.this.firstRequest);
            }
            return DescribeConfigurationTemplatesIterable.this.client.describeConfigurationTemplates((DescribeConfigurationTemplatesRequest)((Object)DescribeConfigurationTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

