/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.ExternalCatalog;
import org.apache.polaris.core.admin.model.PolarisCatalog;
import org.apache.polaris.core.admin.model.StorageConfigInfo;

@ApiModel(description="A catalog object. A catalog may be internal or external. External catalogs are managed entirely by an external catalog interface. Third party catalogs may be other Iceberg REST implementations or other services with their own proprietary APIs")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ExternalCatalog.class, name="EXTERNAL"), @JsonSubTypes.Type(value=PolarisCatalog.class, name="INTERNAL")})
public class Catalog {
    @NotNull
    private final TypeEnum type;
    @NotNull
    @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$")
    @Size(min=1, max=256)
    private final @NotNull @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String name;
    @NotNull
    @Valid
    private final CatalogProperties properties;
    private final Long createTimestamp;
    private final Long lastUpdateTimestamp;
    private final Integer entityVersion;
    @NotNull
    @Valid
    private final StorageConfigInfo storageConfigInfo;

    @ApiModelProperty(required=true, value="the type of catalog - internal or external")
    @JsonProperty(value="type", required=true)
    public TypeEnum getType() {
        return this.type;
    }

    @ApiModelProperty(required=true, value="The name of the catalog")
    @JsonProperty(value="name", required=true)
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="properties", required=true)
    public CatalogProperties getProperties() {
        return this.properties;
    }

    @ApiModelProperty(value="The creation time represented as unix epoch timestamp in milliseconds")
    @JsonProperty(value="createTimestamp")
    public Long getCreateTimestamp() {
        return this.createTimestamp;
    }

    @ApiModelProperty(value="The last update time represented as unix epoch timestamp in milliseconds")
    @JsonProperty(value="lastUpdateTimestamp")
    public Long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    @ApiModelProperty(value="The version of the catalog object used to determine if the catalog metadata has changed")
    @JsonProperty(value="entityVersion")
    public Integer getEntityVersion() {
        return this.entityVersion;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="storageConfigInfo", required=true)
    public StorageConfigInfo getStorageConfigInfo() {
        return this.storageConfigInfo;
    }

    @JsonCreator
    public Catalog(@JsonProperty(value="type", required=true) TypeEnum type, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="properties", required=true) CatalogProperties properties, @JsonProperty(value="createTimestamp") Long createTimestamp, @JsonProperty(value="lastUpdateTimestamp") Long lastUpdateTimestamp, @JsonProperty(value="entityVersion") Integer entityVersion, @JsonProperty(value="storageConfigInfo", required=true) StorageConfigInfo storageConfigInfo) {
        this.type = Objects.requireNonNullElse(type, TypeEnum.INTERNAL);
        this.name = name;
        this.properties = properties;
        this.createTimestamp = createTimestamp;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        this.entityVersion = entityVersion;
        this.storageConfigInfo = storageConfigInfo;
    }

    public Catalog(TypeEnum type, String name, CatalogProperties properties, StorageConfigInfo storageConfigInfo) {
        this.type = Objects.requireNonNullElse(type, TypeEnum.INTERNAL);
        this.name = name;
        this.properties = properties;
        this.createTimestamp = null;
        this.lastUpdateTimestamp = null;
        this.entityVersion = null;
        this.storageConfigInfo = storageConfigInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Catalog catalog = (Catalog)o;
        return Objects.equals((Object)this.type, (Object)catalog.type) && Objects.equals(this.name, catalog.name) && Objects.equals(this.properties, catalog.properties) && Objects.equals(this.createTimestamp, catalog.createTimestamp) && Objects.equals(this.lastUpdateTimestamp, catalog.lastUpdateTimestamp) && Objects.equals(this.entityVersion, catalog.entityVersion) && Objects.equals(this.storageConfigInfo, catalog.storageConfigInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.properties, this.createTimestamp, this.lastUpdateTimestamp, this.entityVersion, this.storageConfigInfo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Catalog {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    createTimestamp: ").append(this.toIndentedString(this.createTimestamp)).append("\n");
        sb.append("    lastUpdateTimestamp: ").append(this.toIndentedString(this.lastUpdateTimestamp)).append("\n");
        sb.append("    entityVersion: ").append(this.toIndentedString(this.entityVersion)).append("\n");
        sb.append("    storageConfigInfo: ").append(this.toIndentedString(this.storageConfigInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class Builder {
        private TypeEnum type;
        private String name;
        private CatalogProperties properties;
        private Long createTimestamp;
        private Long lastUpdateTimestamp;
        private Integer entityVersion;
        private StorageConfigInfo storageConfigInfo;

        private Builder() {
        }

        private Builder(TypeEnum type, String name, CatalogProperties properties, StorageConfigInfo storageConfigInfo) {
            this.type = Objects.requireNonNullElse(type, TypeEnum.INTERNAL);
            this.name = name;
            this.properties = properties;
            this.storageConfigInfo = storageConfigInfo;
        }

        public Builder setType(TypeEnum type) {
            this.type = type;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setProperties(CatalogProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder setCreateTimestamp(Long createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public Builder setLastUpdateTimestamp(Long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public Builder setEntityVersion(Integer entityVersion) {
            this.entityVersion = entityVersion;
            return this;
        }

        public Builder setStorageConfigInfo(StorageConfigInfo storageConfigInfo) {
            this.storageConfigInfo = storageConfigInfo;
            return this;
        }

        public Catalog build() {
            Catalog inst = new Catalog(this.type, this.name, this.properties, this.createTimestamp, this.lastUpdateTimestamp, this.entityVersion, this.storageConfigInfo);
            return inst;
        }
    }
}

