/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License. 
 */


package org.uberfire.client.views.pfly.sys;

import com.google.gwt.core.client.ScriptInjector;
import org.gwtbootstrap3.client.GwtBootstrap3ClientBundle;

import static org.uberfire.client.views.pfly.sys.MomentUtils.setMomentLocale;

/**
 * Utilities for ensuring the PatternFly/BS3 system is working early enough that the app can start correctly.
 */
public class PatternFlyBootstrapper {

    private static boolean isBootstrapSelectLoaded = false;

    private static boolean isMomentLoaded = false;

    private static boolean isMomentTimeZoneLoaded = false;

    private static boolean isPatternFlyLoaded = false;

    private static boolean isMonacoEditorLoaded = false;

    /**
     * Uses GWT's ScriptInjector to put jQuery in the page if it isn't already. All Errai IOC beans that rely on
     * GWTBootstrap 3 widgets should call this before creating their first such widget.
     */
    public static void ensurejQueryIsAvailable() {
        if (!isjQueryLoaded()) {
            ScriptInjector.fromString(GwtBootstrap3ClientBundle.INSTANCE.jQuery().getText())
                    .setWindow(ScriptInjector.TOP_WINDOW)
                    .inject();
        }
    }

    public static void ensureBootstrapSelectIsAvailable() {
        if (!isBootstrapSelectLoaded) {
            ScriptInjector.fromString(PatternFlyClientBundle.INSTANCE.bootstrapSelect().getText())
                    .setWindow(ScriptInjector.TOP_WINDOW)
                    .inject();
            isBootstrapSelectLoaded = true;
        }
    }

    public static void ensurePatternFlyIsAvailable() {
        ensurejQueryIsAvailable();
        ensureBootstrapSelectIsAvailable();
        if (!isPatternFlyLoaded) {
            ScriptInjector.fromString(PatternFlyClientBundle.INSTANCE.patternFly().getText())
                    .setWindow(ScriptInjector.TOP_WINDOW)
                    .inject();
            isPatternFlyLoaded = true;
        }
    }

    public static void ensureMomentIsAvailable() {
        if (!isMomentLoaded) {
            ScriptInjector.fromString(PatternFlyClientBundle.INSTANCE.moment().getText())
                    .setWindow(ScriptInjector.TOP_WINDOW)
                    .inject();
            isMomentLoaded = true;
        }
        setMomentLocale();
    }

    public static void ensureMomentTimeZoneIsAvailable() {
        if (!isMomentTimeZoneLoaded) {
            ScriptInjector.fromString(PatternFlyClientBundle.INSTANCE.momentTimeZone().getText())
                    .setWindow(ScriptInjector.TOP_WINDOW)
                    .inject();
            isMomentTimeZoneLoaded = true;
        }
    }

    public static void ensureMonacoEditorLoaderIsAvailable() {
        if (!isMonacoEditorLoaded) {
            ScriptInjector.fromString(PatternFlyClientBundle.INSTANCE.monacoEditor().getText())
                    .setWindow(ScriptInjector.TOP_WINDOW)
                    .inject();
            isMonacoEditorLoaded = true;
        }
    }

    /**
     * Checks to see if jQuery is already present.
     *
     * @return true is jQuery is loaded, false otherwise.
     */
    private static native boolean isjQueryLoaded() /*-{
        return (typeof $wnd['jQuery'] !== 'undefined');
    }-*/;
}
