/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite3.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite3.internal.sql.engine.rel.AbstractIgniteSpool;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite3.internal.sql.engine.util.RexUtils;
import org.apache.ignite3.internal.util.CollectionUtils;

public class IgniteHashIndexSpool
extends AbstractIgniteSpool {
    private static final String REL_TYPE_NAME = "HashIndexSpool";
    private final List<RexNode> searchRow;
    private final ImmutableBitSet keys;
    private final RexNode cond;
    private final boolean allowNulls;

    public IgniteHashIndexSpool(RelOptCluster cluster, RelTraitSet traits, RelNode input, List<RexNode> searchRow, RexNode cond, boolean allowNulls) {
        super(cluster, traits, Spool.Type.LAZY, input);
        assert (!CollectionUtils.nullOrEmpty(searchRow));
        this.searchRow = searchRow;
        this.cond = cond;
        this.allowNulls = allowNulls;
        this.keys = ImmutableBitSet.of((Iterable)RexUtils.notNullKeys(searchRow));
    }

    public IgniteHashIndexSpool(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), (RelNode)input.getInputs().get(0), input.getExpressionList("searchRow"), input.getExpression("condition"), input.getBoolean("allowNulls", false));
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public RelNode accept(RexShuttle shuttle) {
        RexNode condition0 = shuttle.apply(this.cond);
        List searchRow0 = shuttle.apply(this.searchRow);
        if (condition0 == this.cond && searchRow0 == this.searchRow) {
            return this;
        }
        return new IgniteHashIndexSpool(this.getCluster(), this.getTraitSet(), this.getInput(), searchRow0, condition0, this.allowNulls);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteHashIndexSpool(cluster, this.getTraitSet(), (RelNode)inputs.get(0), this.searchRow, this.cond, this.allowNulls);
    }

    protected Spool copy(RelTraitSet traitSet, RelNode input, Spool.Type readType, Spool.Type writeType) {
        return new IgniteHashIndexSpool(this.getCluster(), traitSet, input, this.searchRow, this.cond, this.allowNulls);
    }

    public boolean isEnforcer() {
        return true;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        RelWriter writer = super.explainTerms(pw);
        return writer.item("searchRow", this.searchRow).item("condition", (Object)this.cond).item("allowNulls", (Object)this.allowNulls);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCnt = mq.getRowCount(this.getInput());
        double bytesPerRow = (double)this.getRowType().getFieldCount() * 4.0;
        double totalBytes = rowCnt * bytesPerRow;
        double cpuCost = 10.0;
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        return costFactory.makeCost(rowCnt, cpuCost, 0.0, totalBytes, 0.0);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return mq.getRowCount(this.getInput()) * mq.getSelectivity((RelNode)this, null);
    }

    public List<RexNode> searchRow() {
        return this.searchRow;
    }

    public ImmutableBitSet keys() {
        return this.keys;
    }

    public RexNode condition() {
        return this.cond;
    }

    public boolean allowNulls() {
        return this.allowNulls;
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }
}

