/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.ChangeIndexStatusValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.StartBuildingIndexCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.catalog.storage.StartBuildingIndexEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;

public class StartBuildingIndexCommand
implements CatalogCommand {
    private final int indexId;

    public static StartBuildingIndexCommandBuilder builder() {
        return new Builder();
    }

    private StartBuildingIndexCommand(int indexId) {
        this.indexId = indexId;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogIndexDescriptor index = CatalogUtils.indexOrThrow(catalog, this.indexId);
        if (index.status() != CatalogIndexStatus.REGISTERED) {
            throw new ChangeIndexStatusValidationException(this.indexId, index.status(), CatalogIndexStatus.BUILDING, CatalogIndexStatus.REGISTERED);
        }
        return List.of(new StartBuildingIndexEntry(this.indexId));
    }

    private static class Builder
    implements StartBuildingIndexCommandBuilder {
        private int indexId;

        private Builder() {
        }

        @Override
        public Builder indexId(int indexId) {
            this.indexId = indexId;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new StartBuildingIndexCommand(this.indexId);
        }
    }
}

