/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationMappingException;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.AllOfTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.OneOfTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.PartitionedTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.SomeOfTarget;
import org.apache.ignite.internal.util.IgniteUtils;

abstract class AbstractTarget
implements ExecutionTarget {
    final long nodes;

    AbstractTarget(long nodes) {
        assert (nodes != 0L) : "Empty target is not allowed";
        this.nodes = nodes;
    }

    List<String> nodes(List<String> nodeNames) {
        if (IgniteUtils.isPow2((long)this.nodes)) {
            int idx = Long.numberOfTrailingZeros(this.nodes);
            return List.of(nodeNames.get(idx));
        }
        int count = Long.bitCount(this.nodes);
        ArrayList<String> result = new ArrayList<String>(count);
        int bit = 1;
        int idx = 0;
        while ((long)bit <= this.nodes) {
            if ((this.nodes & (long)bit) != 0L) {
                result.add(nodeNames.get(idx));
            }
            bit <<= 1;
            ++idx;
        }
        return result;
    }

    Int2ObjectMap<NodeWithConsistencyToken> assignments(List<String> nodeNames) {
        if (!(this instanceof PartitionedTarget)) {
            return Int2ObjectMaps.emptyMap();
        }
        PartitionedTarget partitionedTarget = (PartitionedTarget)this;
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap(partitionedTarget.partitionsNodes.length);
        for (int partNo = 0; partNo < partitionedTarget.partitionsNodes.length; ++partNo) {
            long partitionNodes = partitionedTarget.partitionsNodes[partNo];
            assert (IgniteUtils.isPow2((long)partitionNodes));
            int idx = Long.numberOfTrailingZeros(partitionNodes);
            result.put(partNo, (Object)new NodeWithConsistencyToken(nodeNames.get(idx), partitionedTarget.enlistmentConsistencyTokens[partNo]));
        }
        return result;
    }

    abstract ExecutionTarget finalise();

    abstract ExecutionTarget colocate(AllOfTarget var1) throws ColocationMappingException;

    abstract ExecutionTarget colocate(OneOfTarget var1) throws ColocationMappingException;

    abstract ExecutionTarget colocate(PartitionedTarget var1) throws ColocationMappingException;

    abstract ExecutionTarget colocate(SomeOfTarget var1) throws ColocationMappingException;

    static ExecutionTarget colocate(AllOfTarget allOf, AllOfTarget otherAllOf) throws ColocationMappingException {
        if (allOf.nodes != otherAllOf.nodes) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        return allOf;
    }

    static ExecutionTarget colocate(AllOfTarget allOf, OneOfTarget oneOf) throws ColocationMappingException {
        if ((allOf.nodes & oneOf.nodes) == 0L) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        if (!IgniteUtils.isPow2((long)allOf.nodes)) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        return allOf;
    }

    static ExecutionTarget colocate(AllOfTarget allOf, PartitionedTarget partitioned) throws ColocationMappingException {
        throw new ColocationMappingException("AllOf target and Partitioned can't be colocated");
    }

    static ExecutionTarget colocate(AllOfTarget allOf, SomeOfTarget someOf) throws ColocationMappingException {
        long newNodes = allOf.nodes & someOf.nodes;
        if (allOf.nodes != newNodes) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        return allOf;
    }

    static ExecutionTarget colocate(OneOfTarget oneOf, OneOfTarget anotherOneOf) throws ColocationMappingException {
        long newNodes = oneOf.nodes & anotherOneOf.nodes;
        if (newNodes == 0L) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        return new OneOfTarget(newNodes);
    }

    static ExecutionTarget colocate(OneOfTarget oneOf, PartitionedTarget partitioned) throws ColocationMappingException {
        if ((oneOf.nodes & partitioned.nodes) == 0L) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        if (IgniteUtils.isPow2((long)partitioned.nodes)) {
            return partitioned;
        }
        long colocatedNodes = oneOf.nodes;
        for (int partNo = 0; partNo < partitioned.partitionsNodes.length; ++partNo) {
            if ((colocatedNodes &= partitioned.partitionsNodes[partNo]) != 0L) continue;
            throw new ColocationMappingException("Targets are not colocated");
        }
        boolean finalised = IgniteUtils.isPow2((long)colocatedNodes);
        long[] newNodes = new long[partitioned.partitionsNodes.length];
        Arrays.fill(newNodes, colocatedNodes);
        return new PartitionedTarget(finalised, newNodes, partitioned.enlistmentConsistencyTokens);
    }

    static ExecutionTarget colocate(OneOfTarget oneOf, SomeOfTarget someOf) throws ColocationMappingException {
        long newNodes = oneOf.nodes & someOf.nodes;
        if (newNodes == 0L) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        return new OneOfTarget(newNodes);
    }

    static ExecutionTarget colocate(PartitionedTarget partitioned, PartitionedTarget otherPartitioned) throws ColocationMappingException {
        if (partitioned.partitionsNodes.length != otherPartitioned.partitionsNodes.length) {
            throw new ColocationMappingException("Partitioned targets with not matching numbers of partitions are not colocated");
        }
        boolean finalised = true;
        long[] newPartitionsNodes = new long[partitioned.partitionsNodes.length];
        for (int partNo = 0; partNo < partitioned.partitionsNodes.length; ++partNo) {
            long newNodes = partitioned.partitionsNodes[partNo] & otherPartitioned.partitionsNodes[partNo];
            if (newNodes == 0L) {
                throw new ColocationMappingException("Targets are not colocated");
            }
            newPartitionsNodes[partNo] = newNodes;
            finalised = finalised && IgniteUtils.isPow2((long)newNodes);
        }
        if (!Arrays.equals(partitioned.enlistmentConsistencyTokens, otherPartitioned.enlistmentConsistencyTokens)) {
            throw new ColocationMappingException("Partitioned targets have different terms");
        }
        return new PartitionedTarget(finalised, newPartitionsNodes, partitioned.enlistmentConsistencyTokens);
    }

    static ExecutionTarget colocate(PartitionedTarget partitioned, SomeOfTarget someOf) throws ColocationMappingException {
        boolean finalised = true;
        long[] newPartitionsNodes = new long[partitioned.partitionsNodes.length];
        for (int partNo = 0; partNo < partitioned.partitionsNodes.length; ++partNo) {
            long newNodes = partitioned.partitionsNodes[partNo] & someOf.nodes;
            if (newNodes == 0L) {
                throw new ColocationMappingException("Targets are not colocated");
            }
            newPartitionsNodes[partNo] = newNodes;
            finalised = finalised && IgniteUtils.isPow2((long)newNodes);
        }
        return new PartitionedTarget(finalised, newPartitionsNodes, partitioned.enlistmentConsistencyTokens);
    }

    static ExecutionTarget colocate(SomeOfTarget someOf, SomeOfTarget otherSomeOf) throws ColocationMappingException {
        long newNodes = someOf.nodes & otherSomeOf.nodes;
        if (newNodes == 0L) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        return new SomeOfTarget(newNodes);
    }

    static long pickOne(long nodes) {
        return Long.lowestOneBit(nodes);
    }
}

