/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.JDFieldMap;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDSimpleRow;
import com.ibm.as400.access.SQLChar;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLGraphic;
import com.ibm.as400.access.SQLLongVarchar;
import com.ibm.as400.access.SQLLongVargraphic;
import com.ibm.as400.access.SQLVarchar;
import com.ibm.as400.access.SQLVargraphic;
import java.sql.SQLException;

class JDMappedRow
implements JDRow {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private JDFieldMap[] fieldMaps_;
    private JDRow fromRow_;
    private JDSimpleRow toRow_;

    JDMappedRow(JDSimpleRow formatRow, JDFieldMap[] fieldMaps) {
        this.fieldMaps_ = fieldMaps;
        this.fromRow_ = null;
        this.toRow_ = formatRow;
    }

    JDMappedRow(String[] fieldNames, SQLData[] sqlData, int[] fieldNullables, JDFieldMap[] fieldMaps) {
        this.fieldMaps_ = fieldMaps;
        this.fromRow_ = null;
        this.toRow_ = new JDSimpleRow(fieldNames, sqlData, fieldNullables);
    }

    void setRow(JDRow fromRow) {
        this.fromRow_ = fromRow;
    }

    @Override
    public int findField(String name) throws SQLException {
        return this.toRow_.findField(name);
    }

    @Override
    public int getFieldCount() {
        return this.toRow_.getFieldCount();
    }

    @Override
    public String getFieldName(int index) throws SQLException {
        return this.toRow_.getFieldName(index);
    }

    @Override
    public SQLData getSQLData(int index) throws SQLException {
        SQLData toData = this.toRow_.getSQLData(index);
        toData.set(this.fieldMaps_[index - 1].getValue(this.fromRow_), AS400Calendar.getGregorianInstance(), -1);
        if (toData.getSQLType() == 30) {
            ((SQLVarchar)toData).trim();
        } else if (toData.getSQLType() == 5) {
            ((SQLChar)toData).trim();
        } else if (toData.getSQLType() == 17) {
            ((SQLGraphic)toData).trim();
        } else if (toData.getSQLType() == 32) {
            ((SQLVargraphic)toData).trim();
        } else if (toData.getSQLType() == 19) {
            ((SQLLongVarchar)toData).trim();
        } else if (toData.getSQLType() == 21) {
            ((SQLLongVargraphic)toData).trim();
        }
        return toData;
    }

    @Override
    public SQLData getSQLType(int index) throws SQLException {
        return this.toRow_.getSQLData(index);
    }

    @Override
    public boolean isDataMappingError(int index) throws SQLException {
        return this.fieldMaps_[index - 1].isDataMappingError(this.fromRow_);
    }

    @Override
    public boolean isNull(int index) throws SQLException {
        return this.fieldMaps_[index - 1].isNull(this.fromRow_);
    }

    @Override
    public int isNullable(int index) throws SQLException {
        return this.toRow_.isNullable(index);
    }

    @Override
    public String getSQLTypeName(int index) throws SQLException {
        return this.toRow_.getSQLData(index).getTypeName();
    }

    @Override
    public int getCCSID(int index) throws SQLException {
        SQLData sqlData = this.getSQLType(index);
        if (SQLDataBase.isCharacterType(sqlData.getSQLType())) {
            return -1;
        }
        return 0;
    }
}

