/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class HCSPrepareNewConnReplyDS
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 2024 International Business Machines Corporation and others.";

    HCSPrepareNewConnReplyDS() {
    }

    @Override
    public Object getNewDataStream() {
        return new HCSPrepareNewConnReplyDS();
    }

    int getRC() {
        return this.get32bit(20);
    }

    @Override
    public int hashCode() {
        return 61701;
    }

    void read(InputStream in) throws IOException {
        byte[] header;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving get new connection reply...");
        }
        if (this.readFromStream(in, header = new byte[20], 0, 20) < 20) {
            if (Trace.traceOn_) {
                Trace.log(2, "Failed to read all of the get new connection reply header.");
            }
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToInt(header, 0)];
        System.arraycopy(header, 0, this.data_, 0, 20);
        this.readAfterHeader(in);
    }

    public byte[] getConnReqID() {
        byte[] _connReqID = new byte[64];
        System.arraycopy(this.data_, 24, _connReqID, 0, 64);
        return _connReqID;
    }
}

