/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import java.io.Serializable;
import java.util.Vector;

public abstract class FieldDescription
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    String alias_ = "";
    boolean allowNull_ = false;
    String columnHeading_ = "";
    AS400DataType dataType_ = null;
    String ddsName_ = "";
    Object defaultValue_ = null;
    String[] keyFieldFunctions_ = null;
    int layoutLength_ = 0;
    int layoutAlignment_ = 0;
    int length_;
    String name_ = "";
    String refFil_ = "";
    String refFld_ = "";
    String refFmt_ = "";
    String refLib_ = "";
    String text_ = "";
    boolean isDFTCurrent_ = false;
    String DFTCurrentValue_ = null;
    boolean isDFTNull_ = false;

    protected FieldDescription() {
    }

    protected FieldDescription(AS400DataType dataType, String name) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.dataType_ = dataType;
        this.name_ = name;
        this.ddsName_ = name.length() > 10 ? name.substring(0, 10).toUpperCase() : name.toUpperCase();
        this.length_ = dataType.getByteLength();
    }

    protected FieldDescription(AS400DataType dataType, String name, String ddsName) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (ddsName == null) {
            throw new NullPointerException("ddsName");
        }
        if (ddsName.length() > 10) {
            throw new ExtendedIllegalArgumentException("ddsName", 1);
        }
        this.dataType_ = dataType;
        this.name_ = name;
        this.ddsName_ = ddsName.toUpperCase();
        this.length_ = dataType.getByteLength();
    }

    public String getALIAS() {
        return this.alias_;
    }

    public boolean getALWNULL() {
        return this.allowNull_;
    }

    public String getCOLHDG() {
        return this.columnHeading_;
    }

    public AS400DataType getDataType() {
        return this.dataType_;
    }

    public Object getDFT() {
        return this.defaultValue_;
    }

    public String getDFTCurrentValue() {
        return this.DFTCurrentValue_;
    }

    abstract String[] getDDSDescription();

    public String getDDSName() {
        return this.ddsName_;
    }

    String[] getFieldFunctions() {
        Vector<String> v = new Vector<String>();
        if (!this.alias_.equals("")) {
            v.addElement("ALIAS(" + this.alias_ + ") ");
        }
        if (this.allowNull_) {
            v.addElement("ALWNULL ");
        }
        if (!this.columnHeading_.equals("")) {
            v.addElement("COLHDG(" + this.columnHeading_ + ") ");
        }
        if (!this.refFld_.equals("")) {
            v.addElement("REFFLD(" + this.refFld_ + ") ");
        }
        if (!this.refFil_.equals("")) {
            v.addElement("REFFIL(" + this.refFil_ + ") ");
        }
        if (!this.refFmt_.equals("")) {
            v.addElement("REFFMT(" + this.refFmt_ + ") ");
        }
        if (!this.refLib_.equals("")) {
            v.addElement("REFLIB(" + this.refLib_ + ") ");
        }
        if (!this.text_.equals("")) {
            v.addElement("TEXT('" + this.text_ + "') ");
        }
        if (v.size() != 0) {
            Object[] s = new String[v.size()];
            v.copyInto(s);
            return s;
        }
        return null;
    }

    public String getFieldName() {
        return this.name_;
    }

    public String[] getKeyFieldFunctions() {
        return this.keyFieldFunctions_;
    }

    public int getLayoutAlignment() {
        return this.layoutAlignment_;
    }

    public int getLayoutLength() {
        return this.layoutLength_;
    }

    public int getLength() {
        return this.length_;
    }

    public String getREFFIL() {
        return this.refFil_;
    }

    public String getREFFLD() {
        return this.refFld_;
    }

    public String getREFFMT() {
        return this.refFmt_;
    }

    public String getREFLIB() {
        return this.refLib_;
    }

    public String getTEXT() {
        return this.text_;
    }

    public boolean isDFTCurrent() {
        return this.isDFTCurrent_;
    }

    public void setALIAS(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias");
        }
        this.alias_ = alias;
    }

    public void setALWNULL(boolean allowNull) {
        this.allowNull_ = allowNull;
    }

    public void setCOLHDG(String colHdg) {
        if (colHdg == null) {
            throw new NullPointerException("colHdg");
        }
        this.columnHeading_ = colHdg;
    }

    protected void setDataType(AS400DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = dataType;
    }

    public void setDDSName(String ddsName) {
        if (ddsName == null) {
            throw new NullPointerException("ddsName");
        }
        if (ddsName.length() > 10) {
            throw new ExtendedIllegalArgumentException("ddsName", 1);
        }
        this.ddsName_ = ddsName.toUpperCase();
    }

    public void setFieldName(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        this.name_ = fieldName;
    }

    public void setKeyFieldFunctions(String[] keyFunctions) {
        if (keyFunctions == null) {
            throw new NullPointerException("keyFunctions");
        }
        if (keyFunctions.length == 0) {
            throw new ExtendedIllegalArgumentException("keyFunctions", 1);
        }
        this.keyFieldFunctions_ = keyFunctions;
    }

    public void setLayoutAlignment(int layoutAlignment) {
        if (layoutAlignment != 1 && layoutAlignment != 2) {
            throw new ExtendedIllegalArgumentException("layoutAlignment", 2);
        }
        this.layoutAlignment_ = layoutAlignment;
    }

    public void setLayoutAttributes(int layoutLength, int layoutAlignment) {
        if (layoutLength > 50 || layoutLength < 0) {
            throw new ExtendedIllegalArgumentException("layoutLength", 1);
        }
        if (layoutAlignment != 1 && layoutAlignment != 2) {
            throw new ExtendedIllegalArgumentException("layoutAlignment", 2);
        }
        this.layoutLength_ = layoutLength;
        this.layoutAlignment_ = layoutAlignment;
    }

    public void setLayoutLength(int layoutLength) {
        if (layoutLength > 50 || layoutLength < 0) {
            throw new ExtendedIllegalArgumentException("layoutLength", 1);
        }
        this.layoutLength_ = layoutLength;
    }

    public void setREFFIL(String refFil) {
        if (refFil == null) {
            throw new NullPointerException("refFil");
        }
        this.refFil_ = refFil;
    }

    public void setREFFLD(String refFld) {
        if (refFld == null) {
            throw new NullPointerException("refFld");
        }
        this.refFld_ = refFld;
    }

    public void setREFFMT(String refFmt) {
        if (refFmt == null) {
            throw new NullPointerException("refFmt");
        }
        this.refFmt_ = refFmt;
    }

    public void setREFLIB(String refLib) {
        if (refLib == null) {
            throw new NullPointerException("refLib");
        }
        this.refLib_ = refLib;
    }

    public void setTEXT(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (text.length() > 50) {
            throw new ExtendedIllegalArgumentException("text", 1);
        }
        this.text_ = text;
    }

    public boolean isDFTNull() {
        return this.isDFTNull_;
    }
}

