/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ClusteredHashTableEntry;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ClusteredHashTable
implements Serializable {
    static final long serialVersionUID = 5L;
    public static final int CONSISTENT_ENTRIES = 0;
    public static final int INCONSISTENT_ENTRIES = 1;
    public static final int ALL_ENTRIES = -1;
    static final int SIZE_OF_CHTS0100 = 36;
    static final int SIZE_OF_CHTI0100 = 24;
    static final int SIZE_OF_QUS_EC_T = 272;
    static final int SIZE_OF_KEY = 16;
    static final int MAX_DATA_SIZE = 62000;
    private transient boolean connected_ = false;
    private String name_;
    private transient byte[] connectionHandle_;
    private AS400 system_;
    private static final Object userSpaceLock_ = new Object();
    private transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);

    public ClusteredHashTable() {
    }

    public ClusteredHashTable(AS400 system, String name) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0 || name.length() > 10) {
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        this.system_ = system;
        this.name_ = name;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    private final void checkPropertiesSet() {
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
    }

    public synchronized void close() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (this.connected_) {
            try {
                ProgramParameter[] parameterList = new ProgramParameter[2];
                parameterList[0] = new ProgramParameter(this.connectionHandle_);
                parameterList[0].setParameterType(2);
                byte[] errorCode = new byte[272];
                parameterList[1] = new ProgramParameter(errorCode, 272);
                parameterList[1].setParameterType(2);
                ServiceProgramCall sPGMCall = new ServiceProgramCall(this.system_);
                sPGMCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", parameterList);
                sPGMCall.setProcedureName("QcstDisconnectCHT");
                sPGMCall.setReturnValueFormat(0);
                sPGMCall.suggestThreadsafe();
                if (!sPGMCall.run()) {
                    AS400Message[] messageList = sPGMCall.getMessageList();
                    throw new AS400Exception(messageList);
                }
                this.connectionHandle_ = null;
                this.connected_ = false;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public boolean containsKey(byte[] key) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!this.connected_) {
            this.open();
        }
        try {
            this.get(key);
        }
        catch (AS400Exception e) {
            AS400Message[] messageList = e.getAS400MessageList();
            for (int i = 0; i < messageList.length; ++i) {
                if (!messageList[i].getID().startsWith("CPFBD06")) continue;
                return false;
            }
            throw new AS400Exception(messageList);
        }
        return true;
    }

    public ClusteredHashTableEntry[] elements() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.elements(null, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredHashTableEntry[] elements(String userProfile, String lastModifiedProfile, int status) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        UserSpace usrSpc;
        ServiceProgramCall sPGMCall;
        AS400Bin4 bin4;
        block24: {
            if (userProfile != null && userProfile.length() > 10) {
                throw new ExtendedIllegalArgumentException("userProfile", 1);
            }
            if (lastModifiedProfile != null && lastModifiedProfile.length() > 10) {
                throw new ExtendedIllegalArgumentException("lastModifiedProfile", 1);
            }
            if (status != 0 && status != 1 && status != -1) {
                throw new ExtendedIllegalArgumentException("status", 2);
            }
            if (lastModifiedProfile != null && lastModifiedProfile.length() < 10) {
                StringBuffer buf = new StringBuffer(lastModifiedProfile);
                for (int i = lastModifiedProfile.length(); i < 10; ++i) {
                    buf.append(" ");
                }
                lastModifiedProfile = buf.toString();
            }
            if (!this.connected_) {
                this.open();
            }
            if (userProfile == null) {
                userProfile = "*ALL      ";
            }
            if (lastModifiedProfile == null) {
                lastModifiedProfile = "*ALL      ";
            }
            bin4 = new AS400Bin4();
            sPGMCall = new ServiceProgramCall(this.system_);
            String jobNumber = sPGMCall.getServerJob().getNumber();
            String userSpacePath = "/QSYS.LIB/QUSRSYS.LIB/QCHT" + jobNumber + ".USRSPC";
            usrSpc = new UserSpace(this.system_, userSpacePath);
            ProgramParameter[] parameterList = new ProgramParameter[7];
            try {
                StringBuffer tempName = new StringBuffer(20);
                tempName.append(usrSpc.getName());
                for (int i = usrSpc.getName().length(); i < 10; ++i) {
                    tempName.append(' ');
                }
                tempName.append("QUSRSYS");
                AS400Text text20 = new AS400Text(20, this.system_.getCcsid(), this.system_);
                parameterList[0] = new ProgramParameter(text20.toBytes(tempName.toString()));
                parameterList[0].setParameterType(2);
                AS400Text text8 = new AS400Text(8, this.system_.getCcsid(), this.system_);
                parameterList[1] = new ProgramParameter(text8.toBytes("CHTL0100"));
                parameterList[1].setParameterType(2);
                parameterList[2] = new ProgramParameter(this.connectionHandle_);
                parameterList[2].setParameterType(2);
                AS400Text text10 = new AS400Text(10, this.system_.getCcsid(), this.system_);
                byte[] keyInfo = new byte[24];
                bin4.toBytes(status, keyInfo, 0);
                text10.toBytes(lastModifiedProfile, keyInfo, 4);
                text10.toBytes(userProfile, keyInfo, 14);
                parameterList[3] = new ProgramParameter(keyInfo);
                parameterList[3].setParameterType(2);
                parameterList[4] = new ProgramParameter(bin4.toBytes(24));
                parameterList[4].setParameterType(2);
                parameterList[5] = new ProgramParameter(text8.toBytes("CHTI0100"));
                parameterList[5].setParameterType(2);
                byte[] errorCode = new byte[272];
                parameterList[6] = new ProgramParameter(errorCode, 272);
                parameterList[6].setParameterType(2);
                sPGMCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", parameterList);
                sPGMCall.setProcedureName("QcstListCHTKeys");
                sPGMCall.setReturnValueFormat(0);
                sPGMCall.suggestThreadsafe();
            }
            catch (PropertyVetoException pve) {
                if (!Trace.traceOn_) break block24;
                Trace.log(2, pve);
            }
        }
        ClusteredHashTableEntry[] entries = null;
        Object object = userSpaceLock_;
        synchronized (object) {
            try {
                usrSpc.create(1, true, " ", (byte)0, "CHT Wrapper Space", "*ALL");
                if (!sPGMCall.run()) {
                    AS400Message[] messageList = sPGMCall.getMessageList();
                    throw new AS400Exception(messageList);
                }
                byte[] num = new byte[4];
                usrSpc.read(num, 124);
                int startOfData = bin4.toInt(num);
                usrSpc.read(num, 132);
                int numOfEntries = bin4.toInt(num);
                usrSpc.read(num, 136);
                int entrySize = bin4.toInt(num);
                usrSpc.read(num, 672);
                int keyOffset = bin4.toInt(num);
                Object tempEntry = null;
                entries = new ClusteredHashTableEntry[numOfEntries];
                for (int i = 0; i < numOfEntries; ++i) {
                    byte[] key = new byte[16];
                    usrSpc.read(key, startOfData + keyOffset + entrySize * i);
                    byte[] bb = new byte[1];
                    entries[i] = new ClusteredHashTableEntry(key, bb, 60, 0, 0);
                }
            }
            finally {
                try {
                    if (usrSpc != null) {
                        usrSpc.delete();
                    }
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
            }
        }
        return entries;
    }

    public synchronized byte[] generateKey() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.connected_) {
            this.open();
        }
        AS400Bin4 bin4 = new AS400Bin4();
        byte[] generatedKey = new byte[16];
        try {
            ProgramParameter[] parameterList = new ProgramParameter[4];
            parameterList[0] = new ProgramParameter(generatedKey, 16);
            parameterList[0].setParameterType(2);
            parameterList[1] = new ProgramParameter(bin4.toBytes(16));
            parameterList[1].setParameterType(2);
            parameterList[2] = new ProgramParameter(this.connectionHandle_);
            parameterList[2].setParameterType(2);
            byte[] errorCode = new byte[272];
            parameterList[3] = new ProgramParameter(errorCode, 272);
            parameterList[3].setParameterType(2);
            ServiceProgramCall sPGMCall = new ServiceProgramCall(this.system_);
            sPGMCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", parameterList);
            sPGMCall.setProcedureName("QcstGenerateCHTKey");
            sPGMCall.setReturnValueFormat(0);
            sPGMCall.suggestThreadsafe();
            if (!sPGMCall.run()) {
                AS400Message[] messageList = sPGMCall.getMessageList();
                throw new AS400Exception(messageList);
            }
            generatedKey = parameterList[0].getOutputData();
            if (Trace.isTraceOn()) {
                Trace.log(3, "Successfully generated key:", generatedKey);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return generatedKey;
    }

    public synchronized ClusteredHashTableEntry get(byte[] key) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!this.connected_) {
            this.open();
        }
        AS400Bin4 bin4 = new AS400Bin4();
        byte[] temp = new byte[62000];
        ProgramParameter[] parameterList = new ProgramParameter[7];
        ServiceProgramCall sPGMCall = new ServiceProgramCall(this.getSystem());
        ClusteredHashTableEntry entry = null;
        try {
            parameterList[0] = new ProgramParameter(temp, 62000);
            parameterList[0].setParameterType(2);
            parameterList[1] = new ProgramParameter(bin4.toBytes(62000));
            parameterList[1].setParameterType(2);
            parameterList[2] = new ProgramParameter(this.connectionHandle_);
            parameterList[2].setParameterType(2);
            AS400Text text8 = new AS400Text(8, this.system_.getCcsid(), this.system_);
            parameterList[3] = new ProgramParameter(text8.toBytes("CHTR0100"));
            parameterList[3].setParameterType(2);
            parameterList[4] = new ProgramParameter(bin4.toBytes(key.length));
            parameterList[4].setParameterType(2);
            parameterList[5] = new ProgramParameter(key);
            parameterList[5].setParameterType(2);
            byte[] errorCode = new byte[272];
            parameterList[6] = new ProgramParameter(errorCode, 272);
            parameterList[6].setParameterType(2);
            sPGMCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", parameterList);
            sPGMCall.setProcedureName("QcstRetrieveCHTEntry");
            sPGMCall.setReturnValueFormat(0);
            sPGMCall.suggestThreadsafe();
            if (!sPGMCall.run()) {
                AS400Message[] messageList = sPGMCall.getMessageList();
                throw new AS400Exception(messageList);
            }
            temp = parameterList[0].getOutputData();
            int length = bin4.toInt(temp, 12);
            int entryStatus = bin4.toInt(temp, 16);
            int authorityAccess = bin4.toInt(temp, 20);
            byte[] theData = new byte[length];
            for (int i = 0; i < length; ++i) {
                theData[i] = temp[i + 44];
            }
            byte[] ownerProfile = new byte[10];
            for (int i = 0; i < 10; ++i) {
                ownerProfile[i] = temp[i + 24];
            }
            byte[] modifyProfile = new byte[10];
            for (int i = 0; i < 10; ++i) {
                modifyProfile[i] = temp[i + 34];
            }
            entry = new ClusteredHashTableEntry(key, theData, 60, authorityAccess, 0);
            entry.setOwnerProfile(new String(ownerProfile));
            entry.setModifiedProfile(new String(modifyProfile));
            entry.setEntryStatus(entryStatus);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return entry;
    }

    public String getHandle() {
        if (this.connectionHandle_ == null) {
            return null;
        }
        return new String(this.connectionHandle_);
    }

    public String getName() {
        return this.name_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.connected_ = false;
        this.connectionHandle_ = null;
    }

    public boolean isEmpty() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.connected_) {
            this.open();
        }
        return this.size() == 0;
    }

    public synchronized void open() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        this.checkPropertiesSet();
        if (this.connected_) {
            return;
        }
        try {
            ProgramParameter[] parameterList = new ProgramParameter[3];
            parameterList[0] = new ProgramParameter(this.connectionHandle_, 16);
            parameterList[0].setParameterType(2);
            AS400Text text10 = new AS400Text(10, this.system_.getCcsid(), this.system_);
            parameterList[1] = new ProgramParameter(text10.toBytes(this.name_));
            parameterList[1].setParameterType(2);
            byte[] errorCode = new byte[272];
            parameterList[2] = new ProgramParameter(errorCode, 272);
            parameterList[2].setParameterType(2);
            ServiceProgramCall sPGMCall = new ServiceProgramCall(this.system_);
            sPGMCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", parameterList);
            sPGMCall.setProcedureName("QcstConnectCHT");
            sPGMCall.setReturnValueFormat(0);
            sPGMCall.suggestThreadsafe();
            if (!sPGMCall.run()) {
                AS400Message[] messageList = sPGMCall.getMessageList();
                throw new AS400Exception(messageList);
            }
            this.connectionHandle_ = parameterList[0].getOutputData();
            this.connected_ = true;
            if (Trace.isTraceOn()) {
                Trace.log(3, "Connection handle is:", this.connectionHandle_);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public synchronized void put(ClusteredHashTableEntry entry) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        int i;
        if (entry == null) {
            throw new NullPointerException("entry");
        }
        this.checkPropertiesSet();
        if (entry.getUpdateOption() != 0 && entry.getUpdateOption() != 1) {
            throw new ExtendedIllegalArgumentException("entry", 2);
        }
        if (!this.connected_) {
            this.open();
        }
        AS400Bin4 bin4 = new AS400Bin4();
        byte[] theDescription = new byte[36 + entry.getKey().length + entry.getUserData().length];
        int indx = 0;
        byte[] len = bin4.toBytes(36);
        for (i = 0; i < 4; ++i) {
            theDescription[indx++] = len[i];
        }
        len = bin4.toBytes(entry.getKey().length);
        for (i = 0; i < 4; ++i) {
            theDescription[indx++] = len[i];
        }
        len = bin4.toBytes(36 + entry.getKey().length);
        for (i = 0; i < 4; ++i) {
            theDescription[indx++] = len[i];
        }
        len = bin4.toBytes(entry.getUserData().length);
        for (i = 0; i < 4; ++i) {
            theDescription[indx++] = len[i];
        }
        for (i = 0; i < 8; ++i) {
            theDescription[indx++] = 0;
        }
        len = bin4.toBytes(entry.getUpdateOption());
        for (i = 0; i < 4; ++i) {
            theDescription[indx++] = len[i];
        }
        len = bin4.toBytes(entry.getEntryAuthority());
        for (i = 0; i < 4; ++i) {
            theDescription[indx++] = len[i];
        }
        len = bin4.toBytes(entry.getTimeToLive() / 60);
        for (i = 0; i < 4; ++i) {
            theDescription[indx++] = len[i];
        }
        len = entry.getKey();
        for (i = 0; i < entry.getKey().length; ++i) {
            theDescription[indx++] = len[i];
        }
        len = entry.getUserData();
        for (i = 0; i < entry.getUserData().length; ++i) {
            theDescription[indx++] = len[i];
        }
        try {
            ProgramParameter[] parameterList = new ProgramParameter[4];
            parameterList[0] = new ProgramParameter(this.connectionHandle_);
            parameterList[0].setParameterType(2);
            parameterList[1] = new ProgramParameter(theDescription);
            parameterList[1].setParameterType(2);
            AS400Text text8 = new AS400Text(8, this.system_.getCcsid(), this.system_);
            parameterList[2] = new ProgramParameter(text8.toBytes("CHTS0100"));
            parameterList[2].setParameterType(2);
            byte[] errorCode = new byte[272];
            parameterList[3] = new ProgramParameter(errorCode, 272);
            parameterList[3].setParameterType(2);
            ServiceProgramCall sPGMCall = new ServiceProgramCall(this.system_);
            sPGMCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", parameterList);
            sPGMCall.setProcedureName("QcstStoreCHTEntry");
            sPGMCall.setReturnValueFormat(0);
            sPGMCall.suggestThreadsafe();
            if (!sPGMCall.run()) {
                AS400Message[] messageList = sPGMCall.getMessageList();
                throw new AS400Exception(messageList);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() > 10) {
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        String old = this.name_;
        this.name_ = name;
        this.changes_.firePropertyChange("name", old, this.name_);
    }

    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 old = this.system_;
        this.system_ = system;
        this.changes_.firePropertyChange("system", old, this.system_);
    }

    public int size() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.connected_) {
            this.open();
        }
        ClusteredHashTableEntry[] entriesList = this.elements();
        return entriesList.length;
    }
}

