/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;

public class RoundRobinChannelSelector<T extends IOReadableWritable>
implements ChannelSelector<T> {
    private int nextChannelToSendTo = -1;
    private int numberOfChannels;

    @Override
    public void setup(int numberOfChannels) {
        this.numberOfChannels = numberOfChannels;
    }

    @Override
    public int selectChannel(T record) {
        this.nextChannelToSendTo = (this.nextChannelToSendTo + 1) % this.numberOfChannels;
        return this.nextChannelToSendTo;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }
}

