/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.MonotonicClock;

public interface QueueBackpressure {
    public static final QueueBackpressure NO_OP = timeUnit -> 0L;
    public static final QueueBackpressure DEFAULT = new QueueBackpressure(){
        private final AtomicReference<Impl> state = new AtomicReference<Impl>(QueueBackpressure.noBackpressure(() -> DatabaseDescriptor.getNativeTransportMinBackoffOnQueueOverload(TimeUnit.NANOSECONDS), () -> DatabaseDescriptor.getNativeTransportMaxBackoffOnQueueOverload(TimeUnit.NANOSECONDS)));

        @Override
        public long markAndGetDelay(TimeUnit timeUnit) {
            return this.state.updateAndGet(Impl::mark).delay(timeUnit);
        }
    };

    public long markAndGetDelay(TimeUnit var1);

    public static Impl noBackpressure(LongSupplier minDelayNanos, LongSupplier maxDelayNanos) {
        return new Impl(minDelayNanos, maxDelayNanos, -1L, 0, 0);
    }

    @VisibleForTesting
    public static class Impl {
        private final long appliedAt;
        private final int severityLevel;
        private final int appliedTimes;
        private final LongSupplier minDelayNanos;
        private final LongSupplier maxDelayNanos;

        @VisibleForTesting
        public Impl(LongSupplier minDelayNanos, LongSupplier maxDelayNanos, long appliedAt, int severityLevel, int appliedTimes) {
            this.minDelayNanos = minDelayNanos;
            this.maxDelayNanos = maxDelayNanos;
            this.appliedAt = appliedAt;
            this.severityLevel = severityLevel;
            this.appliedTimes = appliedTimes;
        }

        public Impl mark() {
            return this.mark(MonotonicClock.Global.preciseTime.now());
        }

        @VisibleForTesting
        public Impl mark(long now) {
            if (this.appliedAt > 0L && now - this.appliedAt >= TimeUnit.SECONDS.toNanos(1L)) {
                return new Impl(this.minDelayNanos, this.maxDelayNanos, now, 1, 1);
            }
            if (this.appliedTimes < 10) {
                return new Impl(this.minDelayNanos, this.maxDelayNanos, now, this.severityLevel == 0 ? 1 : this.severityLevel, this.appliedTimes + 1);
            }
            return new Impl(this.minDelayNanos, this.maxDelayNanos, now, this.severityLevel + 1, 1);
        }

        public long appliedAt() {
            return this.appliedAt;
        }

        public long delay(TimeUnit timeUnit) {
            return timeUnit.convert(Math.min(this.maxDelayNanos(), (long)this.severityLevel * this.minDelayNanos()), TimeUnit.NANOSECONDS);
        }

        public long minDelayNanos() {
            return this.minDelayNanos.getAsLong();
        }

        public long maxDelayNanos() {
            return this.maxDelayNanos.getAsLong();
        }

        public String toString() {
            return "QueueBackpressure{appliedAgo=" + (this.appliedAt == -1L ? "never" : Long.valueOf(TimeUnit.NANOSECONDS.toMillis(MonotonicClock.Global.preciseTime.now() - this.appliedAt))) + ", severityLevel=" + this.severityLevel + ", appliedTimes=" + this.appliedTimes + ", currentDelay=" + this.delay(TimeUnit.MILLISECONDS) + "ms" + '}';
        }
    }
}

