/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Optional;
import org.apache.cassandra.schema.TriggerMetadata;

public final class Triggers
implements Iterable<TriggerMetadata> {
    private final ImmutableMap<String, TriggerMetadata> triggers;

    private Triggers(Builder builder) {
        this.triggers = builder.triggers.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Triggers none() {
        return Triggers.builder().build();
    }

    public static Triggers of(TriggerMetadata ... triggers) {
        return Triggers.builder().add(triggers).build();
    }

    public static Triggers of(Iterable<TriggerMetadata> triggers) {
        return Triggers.builder().add(triggers).build();
    }

    @Override
    public Iterator<TriggerMetadata> iterator() {
        return this.triggers.values().iterator();
    }

    public int size() {
        return this.triggers.size();
    }

    public boolean isEmpty() {
        return this.triggers.isEmpty();
    }

    public Optional<TriggerMetadata> get(String name) {
        return Optional.ofNullable(this.triggers.get((Object)name));
    }

    public Triggers with(TriggerMetadata trigger) {
        if (this.get(trigger.name).isPresent()) {
            throw new IllegalStateException(String.format("Trigger %s already exists", trigger.name));
        }
        return Triggers.builder().add(this).add(trigger).build();
    }

    public Triggers without(String name) {
        TriggerMetadata trigger = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Trigger %s doesn't exists", name)));
        return Triggers.builder().add(Iterables.filter((Iterable)this, t -> t != trigger)).build();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Triggers && this.triggers.equals(((Triggers)o).triggers);
    }

    public int hashCode() {
        return this.triggers.hashCode();
    }

    public String toString() {
        return this.triggers.values().toString();
    }

    public static final class Builder {
        final ImmutableMap.Builder<String, TriggerMetadata> triggers = new ImmutableMap.Builder();

        private Builder() {
        }

        public Triggers build() {
            return new Triggers(this);
        }

        public Builder add(TriggerMetadata trigger) {
            this.triggers.put((Object)trigger.name, (Object)trigger);
            return this;
        }

        public Builder add(TriggerMetadata ... triggers) {
            for (TriggerMetadata trigger : triggers) {
                this.add(trigger);
            }
            return this;
        }

        public Builder add(Iterable<TriggerMetadata> triggers) {
            triggers.forEach(this::add);
            return this;
        }
    }
}

