/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.TimeUUID;

public class FinalizePropose
extends RepairMessage {
    public final TimeUUID sessionID;
    public static final IVersionedSerializer<FinalizePropose> serializer = new IVersionedSerializer<FinalizePropose>(){

        @Override
        public void serialize(FinalizePropose msg, DataOutputPlus out, int version) throws IOException {
            msg.sessionID.serialize(out);
        }

        @Override
        public FinalizePropose deserialize(DataInputPlus in, int version) throws IOException {
            return new FinalizePropose(TimeUUID.deserialize(in));
        }

        @Override
        public long serializedSize(FinalizePropose msg, int version) {
            return TimeUUID.sizeInBytes();
        }
    };

    public FinalizePropose(TimeUUID sessionID) {
        super(null);
        assert (sessionID != null);
        this.sessionID = sessionID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinalizePropose that = (FinalizePropose)o;
        return this.sessionID.equals(that.sessionID);
    }

    public int hashCode() {
        return this.sessionID.hashCode();
    }

    public String toString() {
        return "FinalizePropose{sessionID=" + this.sessionID + '}';
    }
}

