/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.ReadableMemory;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.vint.VIntCoding;

@Shared(scope={Shared.Scope.SIMULATION})
public interface DataOutputPlus
extends DataOutput {
    public void write(ByteBuffer var1) throws IOException;

    default public void write(ReadableMemory memory, long offset, long length) throws IOException {
        for (ByteBuffer buffer : memory.asByteBuffers(offset, length)) {
            this.write(buffer);
        }
    }

    default public void writeVInt(long i) throws IOException {
        VIntCoding.writeVInt(i, this);
    }

    default public void writeUnsignedVInt(long i) throws IOException {
        VIntCoding.writeUnsignedVInt(i, this);
    }

    default public void writeBytes(long register, int bytes) throws IOException {
        switch (bytes) {
            case 0: {
                break;
            }
            case 1: {
                this.writeByte((int)(register >>> 56));
                break;
            }
            case 2: {
                this.writeShort((int)(register >> 48));
                break;
            }
            case 3: {
                this.writeShort((int)(register >> 48));
                this.writeByte((int)(register >> 40));
                break;
            }
            case 4: {
                this.writeInt((int)(register >> 32));
                break;
            }
            case 5: {
                this.writeInt((int)(register >> 32));
                this.writeByte((int)(register >> 24));
                break;
            }
            case 6: {
                this.writeInt((int)(register >> 32));
                this.writeShort((int)(register >> 16));
                break;
            }
            case 7: {
                this.writeInt((int)(register >> 32));
                this.writeShort((int)(register >> 16));
                this.writeByte((int)(register >> 8));
                break;
            }
            case 8: {
                this.writeLong(register);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    default public long position() {
        throw new UnsupportedOperationException();
    }

    default public boolean hasPosition() {
        return false;
    }
}

