/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import org.apache.beam.sdk.annotations.Internal;
import org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethodsIf;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class ShardingWritableByteChannel
implements WritableByteChannel {
    public static final @UnknownKeyFor @NonNull @Initialized int ALL_SHARDS = -2;
    private final @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized WritableByteChannel> writers = new ArrayList();

    public @UnknownKeyFor @NonNull @Initialized int getNumShards() {
        return this.writers.size();
    }

    public void addChannel(@UnknownKeyFor @NonNull @Initialized WritableByteChannel writer) {
        this.writers.add(writer);
    }

    public @UnknownKeyFor @NonNull @Initialized WritableByteChannel getChannel(@UnknownKeyFor @NonNull @Initialized int shardNum) {
        return this.writers.get(shardNum);
    }

    public @UnknownKeyFor @NonNull @Initialized int writeToShard(@UnknownKeyFor @NonNull @Initialized int shardNum, @UnknownKeyFor @NonNull @Initialized ByteBuffer src) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (shardNum >= 0) {
            return this.writers.get(shardNum).write(src);
        }
        switch (shardNum) {
            case -2: {
                int size = 0;
                for (WritableByteChannel writer : this.writers) {
                    size += writer.write(src);
                }
                return size;
            }
        }
        throw new IllegalArgumentException("Illegal shard number: " + shardNum);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int write(@UnknownKeyFor @NonNull @Initialized ByteBuffer src) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.writeToShard(-2, src);
    }

    @Override
    @EnsuresCalledMethodsIf(expression={"this"}, result=false, methods={"close"})
    public @UnknownKeyFor @NonNull @Initialized boolean isOpen() {
        for (WritableByteChannel writer : this.writers) {
            if (writer.isOpen()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        for (WritableByteChannel writer : this.writers) {
            writer.close();
        }
    }
}

