/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xmljoin;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.xml.xmljoin.XmlJoin;
import org.apache.hop.pipeline.transforms.xml.xmljoin.XmlJoinData;
import org.w3c.dom.Node;

@Transform(id="XMLJoin", image="XJN.svg", name="i18n::XmlJoin.name", description="i18n::XmlJoin.description", categoryDescription="i18n::XmlJoin.category", keywords={"i18n::XmlJoinMeta.keyword"}, documentationUrl="/pipeline/transforms/xmljoin.html")
@InjectionSupported(localizationPrefix="XmlJoin.Injection.")
public class XmlJoinMeta
extends BaseTransformMeta<XmlJoin, XmlJoinData> {
    private static final Class<?> PKG = XmlJoinMeta.class;
    @Injection(name="COMPLEX_JOIN")
    private boolean complexJoin;
    @Injection(name="TARGET_XML_TRANSFORM")
    private String targetXmlTransform;
    @Injection(name="TARGET_XML_FIELD")
    private String targetXmlField;
    @Injection(name="SOURCE_XML_FIELD")
    private String sourceXmlField;
    @Injection(name="VALUE_XML_FIELD")
    private String valueXmlField;
    @Injection(name="TARGET_XPATH")
    private String targetXPath;
    @Injection(name="SOURCE_XML_TRANSFORM")
    private String sourceXmlTransform;
    @Injection(name="JOIN_COMPARE_FIELD")
    private String joinCompareField;
    @Injection(name="ENCODING")
    private String encoding;
    @Injection(name="OMIT_XML_HEADER")
    private boolean omitXmlHeader;
    @Injection(name="OMIT_NULL_VALUES")
    private boolean omitNullValues;

    public Object clone() {
        XmlJoinMeta retval = (XmlJoinMeta)((Object)super.clone());
        return retval;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.sourceXmlTransform = XmlHandler.getTagValue((Node)transformNode, (String)"sourceXmlTransform");
            this.targetXmlTransform = XmlHandler.getTagValue((Node)transformNode, (String)"targetXmlTransform");
            this.valueXmlField = XmlHandler.getTagValue((Node)transformNode, (String)"valueXmlField");
            this.targetXmlField = XmlHandler.getTagValue((Node)transformNode, (String)"targetXmlField");
            this.sourceXmlField = XmlHandler.getTagValue((Node)transformNode, (String)"sourceXmlField");
            this.targetXPath = XmlHandler.getTagValue((Node)transformNode, (String)"targetXPath");
            this.joinCompareField = XmlHandler.getTagValue((Node)transformNode, (String)"joinCompareField");
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            this.complexJoin = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"complexJoin"));
            this.omitXmlHeader = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"omitXMLHeader"));
            this.omitNullValues = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"omitNullValues"));
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        this.encoding = "UTF-8";
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v = new ValueMetaString(this.getValueXmlField());
        v.setOrigin(name);
        try {
            IRowMeta sourceRowMeta;
            List<String> targetFieldNames = null;
            IRowMeta targetRowMeta = info[0];
            if (targetRowMeta != null) {
                targetFieldNames = Arrays.asList(targetRowMeta.getFieldNames());
            }
            if ((sourceRowMeta = info[1]) != null) {
                for (String fieldName : sourceRowMeta.getFieldNames()) {
                    if (targetFieldNames != null && targetFieldNames.contains(fieldName)) continue;
                    row.removeValueMeta(fieldName);
                }
            }
        }
        catch (HopValueException hopValueException) {
            // empty catch block
        }
        row.addValueMeta((IValueMeta)v);
    }

    public String getXml() {
        StringBuffer xml = new StringBuffer(500);
        xml.append("    ").append(XmlHandler.addTagValue((String)"targetXmlTransform", (String)this.targetXmlTransform));
        xml.append("    ").append(XmlHandler.addTagValue((String)"sourceXmlTransform", (String)this.sourceXmlTransform));
        xml.append("    ").append(XmlHandler.addTagValue((String)"valueXmlField", (String)this.valueXmlField));
        xml.append("    ").append(XmlHandler.addTagValue((String)"targetXmlField", (String)this.targetXmlField));
        xml.append("    ").append(XmlHandler.addTagValue((String)"sourceXmlField", (String)this.sourceXmlField));
        xml.append("    ").append(XmlHandler.addTagValue((String)"complexJoin", (boolean)this.complexJoin));
        xml.append("    ").append(XmlHandler.addTagValue((String)"joinCompareField", (String)this.joinCompareField));
        xml.append("    ").append(XmlHandler.addTagValue((String)"targetXPath", (String)this.targetXPath));
        xml.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        xml.append("    ").append(XmlHandler.addTagValue((String)"omitXMLHeader", (boolean)this.omitXmlHeader));
        xml.append("    ").append(XmlHandler.addTagValue((String)"omitNullValues", (boolean)this.omitNullValues));
        return xml.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (this.targetXmlTransform == null || this.targetXmlTransform.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLTransformNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLTransformSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.targetXmlField == null || this.targetXmlField.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLFieldNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLFieldSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.sourceXmlTransform == null || this.sourceXmlTransform.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLTransformNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLTransformSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.sourceXmlField == null || this.sourceXmlField.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLFieldNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLFieldSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.valueXmlField == null || this.valueXmlField.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.ResultFieldNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.ResultFieldSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.targetXPath == null || this.targetXPath.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXPathNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXPathSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            boolean targetTransformFound = false;
            boolean sourceTransformFound = false;
            for (int i = 0; i < input.length; ++i) {
                if (this.targetXmlTransform != null && this.targetXmlTransform.equals(input[i])) {
                    targetTransformFound = true;
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLTransformFound", (String[])new String[]{this.targetXmlTransform}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                if (this.sourceXmlTransform == null || !this.sourceXmlTransform.equals(input[i])) continue;
                sourceTransformFound = true;
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLTransformFound", (String[])new String[]{this.sourceXmlTransform}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            if (!targetTransformFound) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLTransformNotFound", (String[])new String[]{this.targetXmlTransform}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            if (!sourceTransformFound) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLTransformNotFound", (String[])new String[]{this.sourceXmlTransform}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"XmlJoinMeta.InfoStream.TargetInputStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"XmlJoinMeta.InfoStream.SourceInputStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        for (IStream stream : infoStreams) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public void resetTransformIoMeta() {
    }

    public boolean isComplexJoin() {
        return this.complexJoin;
    }

    public void setComplexJoin(boolean complexJoin) {
        this.complexJoin = complexJoin;
    }

    public String getTargetXmlTransform() {
        return this.targetXmlTransform;
    }

    public void setTargetXmlTransform(String targetXmlTransform) {
        this.targetXmlTransform = targetXmlTransform;
    }

    public String getTargetXmlField() {
        return this.targetXmlField;
    }

    public void setTargetXmlField(String targetXMLfield) {
        this.targetXmlField = targetXMLfield;
    }

    public String getSourceXmlTransform() {
        return this.sourceXmlTransform;
    }

    public void setSourceXmlTransform(String sourceXmlTransform) {
        this.sourceXmlTransform = sourceXmlTransform;
    }

    public String getSourceXmlField() {
        return this.sourceXmlField;
    }

    public void setSourceXmlField(String sourceXMLfield) {
        this.sourceXmlField = sourceXMLfield;
    }

    public String getValueXmlField() {
        return this.valueXmlField;
    }

    public void setValueXmlField(String valueXMLfield) {
        this.valueXmlField = valueXMLfield;
    }

    public String getTargetXPath() {
        return this.targetXPath;
    }

    public void setTargetXPath(String targetXPath) {
        this.targetXPath = targetXPath;
    }

    public String getJoinCompareField() {
        return this.joinCompareField;
    }

    public void setJoinCompareField(String joinCompareField) {
        this.joinCompareField = joinCompareField;
    }

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public boolean isOmitXmlHeader() {
        return this.omitXmlHeader;
    }

    public void setOmitXmlHeader(boolean omitXmlHeader) {
        this.omitXmlHeader = omitXmlHeader;
    }

    public void setOmitNullValues(boolean omitNullValues) {
        this.omitNullValues = omitNullValues;
    }

    public boolean isOmitNullValues() {
        return this.omitNullValues;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

