/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import java.io.IOException;
import java.util.Map;
import org.apache.beam.runners.core.metrics.LabeledMetrics;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.util.HistogramData;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class LatencyRecordingHttpRequestInitializer
implements HttpRequestInitializer {
    public static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType HISTOGRAM_BUCKET_TYPE = HistogramData.LinearBuckets.of((double)0.0, (double)20.0, (int)3000);
    private final @UnknownKeyFor @NonNull @Initialized Histogram requestLatencies;

    public LatencyRecordingHttpRequestInitializer(@UnknownKeyFor @NonNull @Initialized Histogram histogram) {
        this.requestLatencies = histogram;
    }

    public LatencyRecordingHttpRequestInitializer(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> labels) {
        this.requestLatencies = LabeledMetrics.histogram((MonitoringInfoMetricName)MonitoringInfoMetricName.named((String)MonitoringInfoConstants.Urns.API_REQUEST_LATENCIES, labels), (HistogramData.BucketType)HISTOGRAM_BUCKET_TYPE, (boolean)true);
    }

    public void initialize(@UnknownKeyFor @NonNull @Initialized HttpRequest request) throws @UnknownKeyFor @NonNull @Initialized IOException {
        LoggingInterceptor interceptor = new LoggingInterceptor(this.requestLatencies);
        request.setInterceptor((HttpExecuteInterceptor)interceptor);
        request.setResponseInterceptor((HttpResponseInterceptor)interceptor);
    }

    private static class LoggingInterceptor
    implements HttpResponseInterceptor,
    HttpExecuteInterceptor {
        private final @UnknownKeyFor @NonNull @Initialized Histogram requestLatencies;
        private @UnknownKeyFor @NonNull @Initialized long startTime;

        public LoggingInterceptor(@UnknownKeyFor @NonNull @Initialized Histogram requestLatencies) {
            this.requestLatencies = requestLatencies;
        }

        public void interceptResponse(@UnknownKeyFor @NonNull @Initialized HttpResponse response) throws @UnknownKeyFor @NonNull @Initialized IOException {
            long timeToResponse = System.currentTimeMillis() - this.startTime;
            this.requestLatencies.update((double)timeToResponse);
        }

        public void intercept(@UnknownKeyFor @NonNull @Initialized HttpRequest request) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.startTime = System.currentTimeMillis();
        }
    }
}

