/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.slots;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.slots.RequirementMatcher;
import org.apache.flink.runtime.util.ResourceCounter;

public class DefaultRequirementMatcher
implements RequirementMatcher {
    @Override
    public Optional<ResourceProfile> match(ResourceProfile resourceProfile, ResourceCounter totalRequirements, Function<ResourceProfile, Integer> numAssignedResourcesLookup) {
        if (totalRequirements.getResourceCount(resourceProfile) > numAssignedResourcesLookup.apply(resourceProfile)) {
            return Optional.of(resourceProfile);
        }
        for (Map.Entry<ResourceProfile, Integer> requirementCandidate : totalRequirements.getResourcesWithCount()) {
            ResourceProfile requirementProfile = requirementCandidate.getKey();
            if (!resourceProfile.isMatching(requirementProfile) || requirementCandidate.getValue() <= numAssignedResourcesLookup.apply(requirementProfile)) continue;
            return Optional.of(requirementProfile);
        }
        return Optional.empty();
    }
}

