/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.net;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.monetdb.mcl.net.Parameter;
import org.monetdb.mcl.net.Target;
import org.monetdb.mcl.net.ValidationError;

public final class MonetUrlParser {
    private final Target target;
    private final String urlText;
    private final URI url;

    private MonetUrlParser(Target target, String string) throws URISyntaxException {
        this.target = target;
        this.urlText = string;
        switch (string) {
            case "monetdb:-": 
            case "monetdbs:-": {
                throw new URISyntaxException(string, "invalid MonetDB URL");
            }
            case "monetdb://": 
            case "monetdbs://": {
                string = string + "-";
            }
        }
        this.url = new URI(string);
    }

    public static void parse(Target target, String string) throws URISyntaxException, ValidationError {
        if (string.equals("monetdb://")) {
            string = "monetdb:///";
        }
        target.barrier();
        if (string.startsWith("mapi:")) {
            try {
                MonetUrlParser monetUrlParser = new MonetUrlParser(target, string.substring(5));
                monetUrlParser.parseClassic();
            }
            catch (URISyntaxException uRISyntaxException) {
                URISyntaxException uRISyntaxException2 = new URISyntaxException(uRISyntaxException.getInput(), uRISyntaxException.getReason(), -1);
                uRISyntaxException2.setStackTrace(uRISyntaxException.getStackTrace());
                throw uRISyntaxException2;
            }
        } else {
            MonetUrlParser monetUrlParser = new MonetUrlParser(target, string);
            monetUrlParser.parseModern();
        }
        target.barrier();
    }

    public static String percentDecode(String string, String string2) throws URISyntaxException {
        try {
            return URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("should be unreachable: UTF-8 unknown??", unsupportedEncodingException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new URISyntaxException(string2, string + ": invalid percent escape");
        }
    }

    public static String percentEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private void parseModern() throws URISyntaxException, ValidationError {
        String string;
        int n;
        String string2;
        String string3;
        this.clearBasic();
        String string4 = this.url.getScheme();
        if (string4 == null) {
            throw new URISyntaxException(this.urlText, "URL scheme must be monetdb:// or monetdbs://");
        }
        switch (string4) {
            case "monetdb": {
                this.target.setTls(false);
                break;
            }
            case "monetdbs": {
                this.target.setTls(true);
                break;
            }
            default: {
                throw new URISyntaxException(this.urlText, "URL scheme must be monetdb:// or monetdbs://");
            }
        }
        String string5 = this.url.getAuthority();
        if (string5 == null) {
            if (!this.url.getRawSchemeSpecificPart().startsWith("//")) {
                throw new URISyntaxException(this.urlText, "expected //");
            }
            string3 = "";
            string2 = "";
        } else if (string5.equals("-")) {
            string3 = "";
            string2 = "";
        } else if (string5.startsWith("[")) {
            n = string5.indexOf(93);
            if (n < 0) {
                throw new URISyntaxException(this.urlText, "unmatched '['");
            }
            string3 = string5.substring(1, n);
            string2 = string5.substring(n + 1);
        } else {
            n = string5.indexOf(58);
            if (n >= 0) {
                string3 = string5.substring(0, n);
                string2 = string5.substring(n);
            } else {
                string3 = string5;
                string2 = "";
            }
        }
        string3 = Target.unpackHost(string3);
        this.target.setHost(string3);
        if (!string2.isEmpty() && string2.startsWith(":")) {
            string = string2.substring(1);
            try {
                int n2 = Integer.parseInt(string);
                if (n2 <= 0 || n2 > 65535) {
                    string = null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                string = null;
            }
            if (string == null) {
                throw new ValidationError(this.urlText, "invalid port number");
            }
            this.target.setString(Parameter.PORT, string);
        }
        string = this.url.getRawPath();
        String[] stringArray = string.split("/", 4);
        switch (stringArray.length) {
            case 4: {
                this.target.setString(Parameter.TABLE, MonetUrlParser.percentDecode(Parameter.TABLE.name, stringArray[3]));
            }
            case 3: {
                this.target.setString(Parameter.TABLESCHEMA, MonetUrlParser.percentDecode(Parameter.TABLESCHEMA.name, stringArray[2]));
            }
            case 2: {
                this.target.setString(Parameter.DATABASE, MonetUrlParser.percentDecode(Parameter.DATABASE.name, stringArray[1]));
            }
        }
        String string6 = this.url.getRawQuery();
        if (string6 != null) {
            String[] stringArray2 = string6.split("&");
            for (int i = 0; i < stringArray2.length; ++i) {
                n = stringArray2[i].indexOf(61);
                if (n <= 0) {
                    throw new URISyntaxException(stringArray2[i], "invalid key=value pair");
                }
                String string7 = stringArray2[i].substring(0, n);
                Parameter parameter = Parameter.forName(string7 = MonetUrlParser.percentDecode(string7, string7));
                if (parameter != null && parameter.isCore) {
                    throw new URISyntaxException(string7, string7 + "= is not allowed as a query parameter");
                }
                String string8 = stringArray2[i].substring(n + 1);
                this.target.setString(string7, MonetUrlParser.percentDecode(string7, string8));
            }
        }
    }

    private void parseClassic() throws URISyntaxException, ValidationError {
        if (!this.url.getRawSchemeSpecificPart().startsWith("//")) {
            throw new URISyntaxException(this.urlText, "expected //");
        }
        String string = this.url.getScheme();
        if (string == null) {
            string = "";
        }
        switch (string) {
            case "monetdb": {
                this.parseClassicAuthorityAndPath();
                break;
            }
            case "merovingian": {
                boolean bl;
                String string2 = this.url.getRawAuthority();
                boolean bl2 = bl = this.urlText.startsWith("merovingian://proxy?") || this.urlText.equals("merovingian://proxy");
                if (bl) break;
                throw new URISyntaxException(this.urlText, "with mapi:merovingian:, only //proxy is supported");
            }
            default: {
                throw new URISyntaxException(this.urlText, "URL scheme must be mapi:monetdb:// or mapi:merovingian://");
            }
        }
        String string3 = this.url.getRawQuery();
        if (string3 != null) {
            String[] stringArray = string3.split("&");
            for (int i = 0; i < stringArray.length; ++i) {
                String string4;
                String string5 = stringArray[i];
                if (string5.startsWith("language=")) {
                    string4 = string5.substring(9);
                    this.target.setString(Parameter.LANGUAGE, string4);
                    continue;
                }
                if (!string5.startsWith("database=")) continue;
                string4 = string5.substring(9);
                this.target.setString(Parameter.DATABASE, string4);
            }
        }
    }

    private void parseClassicAuthorityAndPath() throws URISyntaxException, ValidationError {
        String string;
        String string2;
        this.clearBasic();
        String string3 = this.url.getRawAuthority();
        if (string3 == null) {
            string2 = "";
            string = "";
        } else {
            if (string3.indexOf(64) >= 0) {
                throw new URISyntaxException(this.urlText, "user@host syntax is not allowed");
            }
            int n = string3.indexOf(58);
            if (n >= 0) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = "";
            }
        }
        if (!string.isEmpty()) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n <= 0) {
                throw new ValidationError(this.urlText, "invalid port number");
            }
            this.target.setString(Parameter.PORT, string);
        }
        String string4 = this.url.getRawPath();
        if (string2.isEmpty() && string.isEmpty()) {
            this.target.clear(Parameter.HOST);
            this.target.setString(Parameter.SOCK, string4 != null ? string4 : "");
        } else {
            this.target.clear(Parameter.SOCK);
            this.target.setString(Parameter.HOST, string2);
            if (string4 != null && !string4.isEmpty()) {
                if (!string4.startsWith("/")) {
                    throw new URISyntaxException(this.urlText, "expect path to start with /");
                }
                String string5 = string4.substring(1);
                this.target.setString(Parameter.DATABASE, string5);
            }
        }
    }

    private void clearBasic() {
        this.target.clear(Parameter.TLS);
        this.target.clear(Parameter.HOST);
        this.target.clear(Parameter.PORT);
        this.target.clear(Parameter.DATABASE);
    }
}

