/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TableDerived;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class QueryExpression
implements RangeGroup {
    public static final int NOUNION = 0;
    public static final int UNION = 1;
    public static final int UNION_ALL = 2;
    public static final int INTERSECT = 3;
    public static final int INTERSECT_ALL = 4;
    public static final int EXCEPT_ALL = 5;
    public static final int EXCEPT = 6;
    public static final int UNION_TERM = 7;
    int columnCount;
    QueryExpression leftQueryExpression;
    QueryExpression rightQueryExpression;
    public SortAndSlice sortAndSlice;
    private int unionType;
    private boolean unionCorresponding;
    private OrderedHashSet<String> unionCorrespondingColumns;
    int[] unionColumnMap;
    Type[] unionColumnTypes;
    boolean isFullOrder;
    List<Expression> unresolvedExpressions;
    boolean isReferencesResolved;
    boolean isPartOneResolved;
    boolean isPartTwoResolved;
    boolean isResolved;
    int persistenceScope = 21;
    ResultMetaData resultMetaData;
    boolean[] accessibleColumns;
    View view;
    boolean isBaseMergeable;
    boolean isMergeable;
    boolean isUpdatable;
    boolean isInsertable;
    boolean isCheckable;
    boolean isTopLevel;
    boolean isRecursive;
    boolean isSingleRow;
    boolean acceptsSequences;
    boolean isCorrelated;
    boolean isTable;
    boolean isValueList;
    boolean lowerCaseResultIdentifier;
    public TableBase resultTable;
    public Index mainIndex;
    public Index fullIndex;
    public Index orderIndex;
    public Index idIndex;
    public Index rowNumIndex;
    TableDerived recursiveWorkTable;
    TableDerived recursiveResultTable;
    RecursiveQuerySettings recursiveSettings;
    TableDerived[] materialiseList = TableDerived.emptyArray;
    ParserDQL.CompileContext compileContext;

    QueryExpression(ParserDQL.CompileContext compileContext) {
        this.compileContext = compileContext;
        this.sortAndSlice = SortAndSlice.noSort;
    }

    public QueryExpression(ParserDQL.CompileContext compileContext, QueryExpression queryExpression) {
        this(compileContext);
        this.sortAndSlice = SortAndSlice.noSort;
        this.leftQueryExpression = queryExpression;
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return RangeVariable.emptyArray;
    }

    @Override
    public void setCorrelated() {
        this.isCorrelated = true;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    public void setSingleRow() {
        this.isSingleRow = true;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    void addUnion(QueryExpression queryExpression, int n) {
        this.sortAndSlice = SortAndSlice.noSort;
        this.rightQueryExpression = queryExpression;
        this.unionType = n;
        this.setFullOrder();
    }

    void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
        sortAndSlice.sortUnion = true;
    }

    public void setUnionCorresoponding() {
        this.unionCorresponding = true;
    }

    public void setUnionCorrespondingColumns(OrderedHashSet<String> orderedHashSet) {
        this.unionCorrespondingColumns = orderedHashSet;
    }

    public void setFullOrder() {
        this.isFullOrder = true;
        if (this.leftQueryExpression != null) {
            this.leftQueryExpression.setFullOrder();
        }
        if (this.rightQueryExpression != null) {
            this.rightQueryExpression.setFullOrder();
        }
    }

    public void resolve(Session session) {
        this.resolveReferences(session, RangeGroup.emptyArray);
        ExpressionColumn.checkColumnsResolved(this.unresolvedExpressions);
        this.resolveTypes(session);
    }

    public void resolve(Session session, RangeGroup[] rangeGroupArray, Type[] typeArray) {
        this.resolveReferences(session, rangeGroupArray);
        ExpressionColumn.checkColumnsResolved(this.unresolvedExpressions);
        this.resolveTypesPartOne(session);
        if (typeArray != null) {
            for (int i = 0; i < this.unionColumnTypes.length && i < typeArray.length; ++i) {
                if (this.unionColumnTypes[i] != null) continue;
                this.unionColumnTypes[i] = typeArray[i];
            }
        }
        this.resolveTypesPartTwo(session);
        this.resolveTypesPartThree(session);
    }

    public void resolveReferences(Session session, RangeGroup[] rangeGroupArray) {
        if (this.isReferencesResolved) {
            return;
        }
        this.leftQueryExpression.resolveReferences(session, rangeGroupArray);
        this.rightQueryExpression.resolveReferences(session, rangeGroupArray);
        this.addUnresolvedExpressions(this.leftQueryExpression.unresolvedExpressions);
        this.addUnresolvedExpressions(this.rightQueryExpression.unresolvedExpressions);
        if (this.leftQueryExpression.isCorrelated || this.rightQueryExpression.isCorrelated) {
            this.setCorrelated();
        }
        if (!this.unionCorresponding) {
            this.columnCount = this.leftQueryExpression.getColumnCount();
            int n = this.rightQueryExpression.getColumnCount();
            if (this.columnCount != n) {
                throw Error.error(5594);
            }
            this.unionColumnTypes = new Type[this.columnCount];
            this.leftQueryExpression.unionColumnMap = this.rightQueryExpression.unionColumnMap = new int[this.columnCount];
            ArrayUtil.fillSequence(this.leftQueryExpression.unionColumnMap);
            this.resolveColumnReferencesInUnionOrderBy();
            this.accessibleColumns = this.leftQueryExpression.accessibleColumns;
            this.isReferencesResolved = true;
            return;
        }
        Object[] objectArray = this.leftQueryExpression.getColumnNames();
        Object[] objectArray2 = this.rightQueryExpression.getColumnNames();
        if (this.unionCorrespondingColumns == null) {
            this.unionCorrespondingColumns = new OrderedHashSet();
            OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
            OrderedIntHashSet orderedIntHashSet2 = new OrderedIntHashSet();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i];
                int n = ArrayUtil.find(objectArray2, string);
                if (string.length() <= 0 || n == -1) continue;
                if (!this.leftQueryExpression.accessibleColumns[i]) {
                    throw Error.error(5578);
                }
                if (!this.rightQueryExpression.accessibleColumns[n]) {
                    throw Error.error(5578);
                }
                orderedIntHashSet.add(i);
                orderedIntHashSet2.add(n);
                this.unionCorrespondingColumns.add(string);
            }
            if (this.unionCorrespondingColumns.isEmpty()) {
                throw Error.error(5578);
            }
            this.leftQueryExpression.unionColumnMap = orderedIntHashSet.toArray();
            this.rightQueryExpression.unionColumnMap = orderedIntHashSet2.toArray();
        } else {
            this.leftQueryExpression.unionColumnMap = new int[this.unionCorrespondingColumns.size()];
            this.rightQueryExpression.unionColumnMap = new int[this.unionCorrespondingColumns.size()];
            for (int i = 0; i < this.unionCorrespondingColumns.size(); ++i) {
                String string = this.unionCorrespondingColumns.get(i);
                int n = ArrayUtil.find(objectArray, string);
                if (n == -1) {
                    throw Error.error(5501);
                }
                if (!this.leftQueryExpression.accessibleColumns[n]) {
                    throw Error.error(5578);
                }
                this.leftQueryExpression.unionColumnMap[i] = n;
                n = ArrayUtil.find(objectArray2, string);
                if (n == -1) {
                    throw Error.error(5501);
                }
                if (!this.rightQueryExpression.accessibleColumns[n]) {
                    throw Error.error(5578);
                }
                this.rightQueryExpression.unionColumnMap[i] = n;
            }
        }
        this.columnCount = this.unionCorrespondingColumns.size();
        this.unionColumnTypes = new Type[this.columnCount];
        this.resolveColumnReferencesInUnionOrderBy();
        this.accessibleColumns = new boolean[this.columnCount];
        ArrayUtil.fillArray(this.accessibleColumns, true);
        this.isReferencesResolved = true;
    }

    void resolveColumnReferencesInUnionOrderBy() {
        int n = this.sortAndSlice.getOrderLength();
        if (n == 0) {
            return;
        }
        Object[] objectArray = this.getColumnNames();
        for (int i = 0; i < n; ++i) {
            int n2;
            Expression expression = this.sortAndSlice.exprList.get(i);
            Expression expression2 = expression.getLeftNode();
            if (expression2.getType() == 1) {
                if (expression2.getDataType().typeCode == 4 && 0 < (n2 = ((Integer)expression2.getValue(null)).intValue()) && n2 <= objectArray.length) {
                    expression.getLeftNode().resultTableColumnIndex = n2 - 1;
                    continue;
                }
            } else if (expression2.getType() == 2 && (n2 = ArrayUtil.find(objectArray, expression2.getColumnName())) >= 0) {
                expression.getLeftNode().resultTableColumnIndex = n2;
                continue;
            }
            throw Error.error(5576);
        }
        this.sortAndSlice.prepare(0);
    }

    private void addUnresolvedExpressions(List<Expression> list) {
        if (list == null) {
            return;
        }
        if (this.unresolvedExpressions == null) {
            this.unresolvedExpressions = new ArrayListIdentity<Expression>();
        }
        this.unresolvedExpressions.addAll(list);
    }

    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        this.resolveTypesPartThree(session);
    }

    void resolveTypesPartOne(Session session) {
        if (this.isPartOneResolved) {
            return;
        }
        ArrayUtil.projectRowReverse(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.leftQueryExpression.resolveTypesPartOne(session);
        ArrayUtil.projectRow(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        ArrayUtil.projectRowReverse(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.rightQueryExpression.resolveTypesPartOne(session);
        ArrayUtil.projectRow(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.isPartOneResolved = true;
    }

    void resolveTypesPartTwoRecursive(Session session) {
        this.resolveTypesPartTwo(session);
    }

    void resolveTypesPartTwo(Session session) {
        if (this.isPartTwoResolved) {
            return;
        }
        ArrayUtil.projectRowReverse(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        if (this.isRecursive) {
            this.leftQueryExpression.resolveTypesPartTwoRecursive(session);
            this.recursiveWorkTable.colTypes = this.leftQueryExpression.getColumnTypes();
            for (int i = 0; i < this.recursiveWorkTable.colTypes.length; ++i) {
                this.recursiveWorkTable.getColumn(i).setType(this.recursiveWorkTable.colTypes[i]);
            }
            this.recursiveWorkTable.getFullIndex(session);
        } else {
            this.leftQueryExpression.resolveTypesPartTwo(session);
        }
        this.leftQueryExpression.resolveTypesPartThree(session);
        ArrayUtil.projectRowReverse(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.rightQueryExpression.resolveTypesPartTwo(session);
        this.rightQueryExpression.resolveTypesPartThree(session);
        ResultMetaData resultMetaData = this.leftQueryExpression.getMetaData();
        ResultMetaData resultMetaData2 = this.rightQueryExpression.getMetaData();
        for (int i = 0; i < this.leftQueryExpression.unionColumnMap.length; ++i) {
            int n = this.leftQueryExpression.unionColumnMap[i];
            int n2 = this.rightQueryExpression.unionColumnMap[i];
            ColumnBase columnBase = resultMetaData.columns[n];
            byte by = resultMetaData.columns[n].getNullability();
            byte by2 = resultMetaData2.columns[n2].getNullability();
            if (by2 != 1 && (by2 != 2 || by != 0)) continue;
            if (columnBase instanceof ColumnSchema) {
                columnBase = new ColumnBase();
                columnBase.setType(this.leftQueryExpression.unionColumnTypes[i]);
                resultMetaData.columns[n] = columnBase;
            }
            columnBase.setNullability(by2);
        }
        if (this.unionCorresponding || this.isRecursive) {
            this.resultMetaData = this.leftQueryExpression.getMetaData().getNewMetaData(this.leftQueryExpression.unionColumnMap);
            this.createTable(session);
        }
        if (this.sortAndSlice.hasOrder()) {
            QueryExpression queryExpression = this;
            while (true) {
                if (queryExpression.leftQueryExpression == null || queryExpression.unionCorresponding) {
                    this.sortAndSlice.setIndex(session, queryExpression.resultTable);
                    break;
                }
                queryExpression = queryExpression.leftQueryExpression;
            }
        }
        this.isPartTwoResolved = true;
    }

    void resolveTypesPartThree(Session session) {
        this.compileContext = null;
        this.isResolved = true;
    }

    public Object[] getValues(Session session) {
        Result result = this.getResult(session, 2);
        int n = result.getNavigator().getSize();
        if (n == 0) {
            return new Object[result.metaData.getColumnCount()];
        }
        if (n == 1) {
            return result.getSingleRowData();
        }
        throw Error.error(3201);
    }

    public void addExtraConditions(Expression expression) {
    }

    public Object[] getSingleRowValues(Session session) {
        Result result = this.getResult(session, 2);
        int n = result.getNavigator().getSize();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return result.getSingleRowData();
        }
        throw Error.error(3201);
    }

    public Object getValue(Session session) {
        Object[] objectArray = this.getValues(session);
        return objectArray[0];
    }

    Result getResult(Session session, int n) {
        Object object;
        if (this.isRecursive) {
            return this.getResultRecursive(session);
        }
        int n2 = this.unionType == 2 ? n : 0;
        Result result = this.leftQueryExpression.getResult(session, n2);
        RowSetNavigatorData rowSetNavigatorData = (RowSetNavigatorData)result.getNavigator();
        Result result2 = this.rightQueryExpression.getResult(session, n2);
        Object object2 = (RowSetNavigatorData)result2.getNavigator();
        if (this.unionCorresponding) {
            boolean bl = session.resultMaxMemoryRows == 0 || rowSetNavigatorData.getSize() < session.resultMaxMemoryRows && ((RowSetNavigator)object2).getSize() < session.resultMaxMemoryRows;
            object = bl ? new RowSetNavigatorData(session, this) : new RowSetNavigatorDataTable(session, this);
            ((RowSetNavigatorData)object).copy(rowSetNavigatorData, this.leftQueryExpression.unionColumnMap);
            rowSetNavigatorData.release();
            rowSetNavigatorData = object;
            result.setNavigator(rowSetNavigatorData);
            result.metaData = this.getMetaData();
            object = bl ? new RowSetNavigatorData(session, this) : new RowSetNavigatorDataTable(session, this);
            ((RowSetNavigatorData)object).copy((RowIterator)object2, this.rightQueryExpression.unionColumnMap);
            ((RowSetNavigatorData)object2).release();
            object2 = object;
        }
        switch (this.unionType) {
            case 1: {
                rowSetNavigatorData.union((RowSetNavigatorData)object2);
                break;
            }
            case 2: {
                rowSetNavigatorData.unionAll((RowSetNavigatorData)object2);
                break;
            }
            case 3: {
                rowSetNavigatorData.intersect((RowSetNavigatorData)object2);
                break;
            }
            case 4: {
                rowSetNavigatorData.intersectAll((RowSetNavigatorData)object2);
                break;
            }
            case 6: {
                rowSetNavigatorData.except((RowSetNavigatorData)object2);
                break;
            }
            case 5: {
                rowSetNavigatorData.exceptAll((RowSetNavigatorData)object2);
                break;
            }
            default: {
                throw Error.runtimeError(201, "QueryExpression");
            }
        }
        ((RowSetNavigatorData)object2).release();
        if (this.sortAndSlice.hasOrder()) {
            rowSetNavigatorData.sortOrderUnion(this.sortAndSlice);
        }
        if (this.sortAndSlice.hasLimit()) {
            object = this.sortAndSlice.getLimits(session, this, n);
            rowSetNavigatorData.trim((int)object[0], (int)object[1]);
        }
        rowSetNavigatorData.reset();
        return result;
    }

    public void setRecursiveQuerySettings(RecursiveQuerySettings recursiveQuerySettings) {
        OrderedHashSet<TableDerived> orderedHashSet = this.rightQueryExpression.getSubqueries();
        if (orderedHashSet == null) {
            orderedHashSet = new OrderedHashSet();
        }
        block0: for (int i = 0; i < orderedHashSet.size(); ++i) {
            QueryExpression queryExpression;
            TableDerived tableDerived = orderedHashSet.get(i);
            if (tableDerived.isCorrelated() || (queryExpression = tableDerived.queryExpression) == null) continue;
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = new OrderedHashSet<HsqlNameManager.HsqlName>();
            queryExpression.collectObjectNames(orderedHashSet2);
            for (int j = 0; j < orderedHashSet2.size(); ++j) {
                HsqlNameManager.HsqlName hsqlName = orderedHashSet2.get(j);
                if (hsqlName != this.recursiveWorkTable.tableName && hsqlName != this.recursiveResultTable.tableName) continue;
                this.materialiseList = ArrayUtil.toAdjustedArray(this.materialiseList, tableDerived);
                continue block0;
            }
        }
        this.recursiveSettings = recursiveQuerySettings;
    }

    Result getResultRecursive(Session session) {
        RowSetNavigatorData rowSetNavigatorData = new RowSetNavigatorData(session, this);
        Result result = this.leftQueryExpression.getResult(session, 0);
        PersistentStore persistentStore = this.recursiveWorkTable.getRowStore(session);
        PersistentStore persistentStore2 = this.recursiveResultTable.getRowStore(session);
        result.getNavigator().reset();
        this.recursiveWorkTable.insertSys(session, persistentStore, result);
        result.getNavigator().reset();
        this.recursiveResultTable.insertSys(session, persistentStore2, result);
        rowSetNavigatorData.unionAll((RowSetNavigatorData)result.getNavigator());
        int n = 0;
        while (true) {
            for (int i = 0; i < this.materialiseList.length; ++i) {
                this.materialiseList[i].materialise(session);
            }
            Result result2 = this.rightQueryExpression.getResult(session, 0);
            RowSetNavigatorData rowSetNavigatorData2 = (RowSetNavigatorData)result2.getNavigator();
            if (rowSetNavigatorData2.isEmpty()) break;
            int n2 = rowSetNavigatorData.getSize();
            switch (this.unionType) {
                case 1: {
                    rowSetNavigatorData.union(rowSetNavigatorData2);
                    break;
                }
                case 2: {
                    rowSetNavigatorData.unionAll(rowSetNavigatorData2);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "QueryExpression");
                }
            }
            if (n2 == rowSetNavigatorData.getSize()) break;
            if (n > session.database.sqlMaxRecursive) {
                throw Error.error(3474);
            }
            rowSetNavigatorData2.reset();
            this.recursiveResultTable.insertSys(session, persistentStore2, result2);
            persistentStore.removeAll();
            rowSetNavigatorData2.reset();
            this.recursiveWorkTable.insertSys(session, persistentStore, result2);
            ++n;
        }
        Result result3 = Result.newResult(rowSetNavigatorData);
        result3.metaData = this.resultMetaData;
        return result3;
    }

    public OrderedHashSet<TableDerived> getSubqueries() {
        OrderedHashSet<TableDerived> orderedHashSet = this.leftQueryExpression.getSubqueries();
        orderedHashSet = OrderedHashSet.addAll(orderedHashSet, this.rightQueryExpression.getSubqueries());
        return orderedHashSet;
    }

    public boolean isSingleColumn() {
        return this.leftQueryExpression.isSingleColumn();
    }

    public ResultMetaData getMetaData() {
        if (this.resultMetaData != null) {
            return this.resultMetaData;
        }
        return this.leftQueryExpression.getMetaData();
    }

    public QuerySpecification getMainSelect() {
        if (this.leftQueryExpression == null) {
            return (QuerySpecification)this;
        }
        return this.leftQueryExpression.getMainSelect();
    }

    public String describe(Session session, int n) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        switch (this.unionType) {
            case 1: {
                string = "UNION";
                break;
            }
            case 2: {
                string = "UNION ALL";
                break;
            }
            case 3: {
                string = "INTERSECT";
                break;
            }
            case 4: {
                string = "INTERSECT ALL";
                break;
            }
            case 6: {
                string = "EXCEPT";
                break;
            }
            case 5: {
                string = "EXCEPT ALL";
                break;
            }
            default: {
                throw Error.runtimeError(201, "QueryExpression");
            }
        }
        stringBuilder2.append((CharSequence)stringBuilder).append(string).append("\n").append((CharSequence)stringBuilder).append("Left Query=[\n").append((CharSequence)stringBuilder).append(this.leftQueryExpression.describe(session, n + 2)).append((CharSequence)stringBuilder).append("]\n").append((CharSequence)stringBuilder).append("Right Query=[\n").append((CharSequence)stringBuilder).append(this.rightQueryExpression.describe(session, n + 2)).append((CharSequence)stringBuilder).append("]\n");
        return stringBuilder2.toString();
    }

    public List<Expression> getUnresolvedExpressions() {
        return this.unresolvedExpressions;
    }

    public boolean areColumnsResolved() {
        if (this.unresolvedExpressions == null || this.unresolvedExpressions.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.unresolvedExpressions.size(); ++i) {
            Expression expression = this.unresolvedExpressions.get(i);
            if (expression.getRangeVariable() == null) {
                return false;
            }
            if (expression.getRangeVariable().rangeType != 1) continue;
            return false;
        }
        return true;
    }

    String[] getColumnNames() {
        if (this.unionCorrespondingColumns == null) {
            return this.leftQueryExpression.getColumnNames();
        }
        String[] stringArray = new String[this.unionCorrespondingColumns.size()];
        this.unionCorrespondingColumns.toArray(stringArray);
        return stringArray;
    }

    public Type[] getColumnTypes() {
        return this.unionColumnTypes;
    }

    public int getColumnCount() {
        if (this.unionCorrespondingColumns == null) {
            int n;
            int n2 = this.leftQueryExpression.getColumnCount();
            if (n2 != (n = this.rightQueryExpression.getColumnCount())) {
                throw Error.error(5594);
            }
            return n2;
        }
        return this.unionCorrespondingColumns.size();
    }

    public OrderedHashSet<Expression> collectAllExpressions(OrderedHashSet<Expression> orderedHashSet, OrderedIntHashSet orderedIntHashSet, OrderedIntHashSet orderedIntHashSet2) {
        orderedHashSet = this.leftQueryExpression.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        if (this.rightQueryExpression != null) {
            orderedHashSet = this.rightQueryExpression.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        return orderedHashSet;
    }

    OrderedHashSet<RangeVariable> collectRangeVariables(RangeVariable[] rangeVariableArray, OrderedHashSet<RangeVariable> orderedHashSet) {
        orderedHashSet = this.leftQueryExpression.collectRangeVariables(rangeVariableArray, orderedHashSet);
        if (this.rightQueryExpression != null) {
            orderedHashSet = this.rightQueryExpression.collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        return orderedHashSet;
    }

    OrderedHashSet<RangeVariable> collectRangeVariables(OrderedHashSet<RangeVariable> orderedHashSet) {
        orderedHashSet = this.leftQueryExpression.collectRangeVariables(orderedHashSet);
        if (this.rightQueryExpression != null) {
            orderedHashSet = this.rightQueryExpression.collectRangeVariables(orderedHashSet);
        }
        return orderedHashSet;
    }

    public void collectObjectNames(Set<HsqlNameManager.HsqlName> set) {
        this.leftQueryExpression.collectObjectNames(set);
        if (this.rightQueryExpression != null) {
            this.rightQueryExpression.collectObjectNames(set);
        }
    }

    public OrderedHashMap<String, ColumnSchema> getColumns() {
        TableDerived tableDerived = (TableDerived)this.getResultTable();
        return tableDerived.columnList;
    }

    public void setView(View view) {
        this.view = view;
        this.isUpdatable = true;
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    public void setTableColumnNames(OrderedHashMap<String, ColumnSchema> orderedHashMap) {
        if (this.resultTable != null) {
            ((TableDerived)this.resultTable).columnList = orderedHashMap;
            return;
        }
        this.leftQueryExpression.setTableColumnNames(orderedHashMap);
    }

    void createTable(Session session) {
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder()) {
            this.orderIndex = this.sortAndSlice.getNewIndex(session, this.resultTable);
        }
        int[] nArray = new int[this.columnCount];
        ArrayUtil.fillSequence(nArray);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
    }

    void createResultTable(Session session) {
        HsqlNameManager.HsqlName hsqlName = session.database.nameManager.getSubqueryTableName();
        int n = this.persistenceScope == 21 ? 2 : 9;
        OrderedHashMap<String, ColumnSchema> orderedHashMap = this.leftQueryExpression.getUnionColumns();
        this.resultTable = new TableDerived(session.database, hsqlName, n, this.unionColumnTypes, orderedHashMap, ValuePool.emptyIntArray);
    }

    public void setColumnsDefined() {
        if (this.leftQueryExpression != null) {
            this.leftQueryExpression.setColumnsDefined();
        }
    }

    public void setReturningResult() {
        if (this.compileContext.getSequences().length > 0) {
            throw Error.error(5598);
        }
        this.isTopLevel = true;
        this.setReturningResultSet();
    }

    void setReturningResultSet() {
        if (this.unionCorresponding) {
            this.persistenceScope = 23;
            return;
        }
        this.leftQueryExpression.setReturningResultSet();
    }

    private OrderedHashMap<String, ColumnSchema> getUnionColumns() {
        if (this.unionCorresponding || this.leftQueryExpression == null) {
            OrderedHashMap orderedHashMap = ((TableDerived)this.resultTable).columnList;
            OrderedHashMap<String, ColumnSchema> orderedHashMap2 = new OrderedHashMap<String, ColumnSchema>();
            for (int i = 0; i < this.unionColumnMap.length; ++i) {
                ColumnSchema columnSchema = (ColumnSchema)orderedHashMap.get(this.unionColumnMap[i]);
                String string = (String)orderedHashMap.getKeyAt(this.unionColumnMap[i]);
                orderedHashMap2.add(string, columnSchema);
            }
            return orderedHashMap2;
        }
        return this.leftQueryExpression.getUnionColumns();
    }

    public HsqlNameManager.HsqlName[] getResultColumnNames() {
        if (this.resultTable == null) {
            return this.leftQueryExpression.getResultColumnNames();
        }
        OrderedHashMap orderedHashMap = ((TableDerived)this.resultTable).columnList;
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[orderedHashMap.size()];
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            hsqlNameArray[i] = ((ColumnSchema)orderedHashMap.get(i)).getName();
        }
        return hsqlNameArray;
    }

    public TableBase getResultTable() {
        if (this.resultTable != null) {
            return this.resultTable;
        }
        if (this.leftQueryExpression != null) {
            return this.leftQueryExpression.getResultTable();
        }
        return null;
    }

    public Table getBaseTable() {
        return null;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public boolean isInsertable() {
        return this.isInsertable;
    }

    public int[] getBaseTableColumnMap() {
        return null;
    }

    public Expression getCheckCondition() {
        return null;
    }

    public boolean hasReference(RangeVariable rangeVariable) {
        if (this.leftQueryExpression.hasReference(rangeVariable)) {
            return true;
        }
        return this.rightQueryExpression.hasReference(rangeVariable);
    }

    void getBaseTableNames(OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        this.leftQueryExpression.getBaseTableNames(orderedHashSet);
        this.rightQueryExpression.getBaseTableNames(orderedHashSet);
    }

    boolean isEquivalent(QueryExpression queryExpression) {
        return this.leftQueryExpression.isEquivalent(queryExpression.leftQueryExpression) && this.unionType == queryExpression.unionType && (this.rightQueryExpression == null ? queryExpression.rightQueryExpression == null : this.rightQueryExpression.isEquivalent(queryExpression.rightQueryExpression));
    }

    public void replaceColumnReferences(Session session, RangeVariable rangeVariable, Expression[] expressionArray) {
        this.leftQueryExpression.replaceColumnReferences(session, rangeVariable, expressionArray);
        this.rightQueryExpression.replaceColumnReferences(session, rangeVariable, expressionArray);
    }

    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        this.leftQueryExpression.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        this.rightQueryExpression.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
    }

    public void replaceExpressions(OrderedHashSet<Expression> orderedHashSet, int n) {
        this.leftQueryExpression.replaceExpressions(orderedHashSet, n);
        this.rightQueryExpression.replaceExpressions(orderedHashSet, n);
    }

    public void setAsExists() {
    }

    public void setLowerCaseResultIdentifer() {
        this.lowerCaseResultIdentifier = true;
    }

    static class RecursiveQuerySettings {
        static final int none = 0;
        static final int depthFirst = 1;
        static final int breadthFirst = 2;
        static final int findCycle = 1;
        int searchOrderType;
        SortAndSlice searchOrderSort;
        ColumnSchema searchOrderSetColumn;
        int cycle;
        int[] cycleColumnList;
        ColumnSchema cycleColumnFirst;
        ColumnSchema cycleMarkColumn;
        String cycleMarkValue;
        String noCycleMarkValue;
        ColumnSchema cyclePathColumn;

        RecursiveQuerySettings() {
        }
    }
}

