/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getvariable;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IIntCodeConverter;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getvariable.GetVariable;
import org.apache.hop.pipeline.transforms.getvariable.GetVariableData;

@Transform(id="GetVariable", image="getvariable.svg", name="i18n::GetVariable.Name", description="i18n::GetVariable.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Workflow", keywords={"i18n::GetVariableMeta.keyword"}, documentationUrl="/pipeline/transforms/getvariable.html")
public class GetVariableMeta
extends BaseTransformMeta<GetVariable, GetVariableData> {
    private static final Class<?> PKG = GetVariableMeta.class;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS", injectionGroupDescription="GetVariable.Injection.FIELDS")
    private List<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();

    public GetVariableMeta() {
    }

    public GetVariableMeta(GetVariableMeta m) {
        this();
        m.fieldDefinitions.forEach(f -> this.fieldDefinitions.add(new FieldDefinition((FieldDefinition)f)));
    }

    public GetVariableMeta clone() {
        return new GetVariableMeta(this);
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            for (FieldDefinition fieldDefinition : this.fieldDefinitions) {
                IValueMeta valueMeta = fieldDefinition.createValueMeta();
                valueMeta.setOrigin(name);
                rowMeta.addValueMeta(valueMeta);
            }
        }
        catch (HopPluginException e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        int nrRemarks = remarks.size();
        for (FieldDefinition fieldDefinition : this.fieldDefinitions) {
            if (!Utils.isEmpty((CharSequence)fieldDefinition.getVariableString())) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetVariableMeta.CheckResult.VariableNotSpecified", (String[])new String[]{fieldDefinition.getFieldName()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetVariableMeta.CheckResult.AllVariablesSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public List<FieldDefinition> getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    public void setFieldDefinitions(List<FieldDefinition> fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
    }

    public static final class FieldDefinition {
        @HopMetadataProperty(key="name", injectionKey="FIELDNAME", injectionKeyDescription="GetVariable.Injection.FIELDNAME")
        private String fieldName;
        @HopMetadataProperty(key="variable", injectionKey="VARIABLE", injectionKeyDescription="GetVariable.Injection.VARIABLE")
        private String variableString;
        @HopMetadataProperty(key="type", injectionKey="FIELDTYPE", injectionKeyDescription="GetVariable.Injection.FIELDTYPE", intCodeConverter=IntTypeConverter.class)
        private String fieldType;
        @HopMetadataProperty(key="format", injectionKey="FIELDFORMAT", injectionKeyDescription="GetVariable.Injection.FIELDFORMAT")
        private String fieldFormat;
        @HopMetadataProperty(key="length", injectionKey="FIELDLENGTH", injectionKeyDescription="GetVariable.Injection.FIELDLENGTH")
        private int fieldLength;
        @HopMetadataProperty(key="precision", injectionKey="FIELDPRECISION", injectionKeyDescription="GetVariable.Injection.FIELDPRECISION")
        private int fieldPrecision;
        @HopMetadataProperty(key="currency", injectionKey="CURRENCY", injectionKeyDescription="GetVariable.Injection.CURRENCY")
        private String currency;
        @HopMetadataProperty(key="decimal", injectionKey="DECIMAL", injectionKeyDescription="GetVariable.Injection.DECIMAL")
        private String decimal;
        @HopMetadataProperty(key="group", injectionKey="GROUP", injectionKeyDescription="GetVariable.Injection.GROUP")
        private String group;
        @HopMetadataProperty(key="trim_type", storeWithCode=true, injectionKey="TRIMTYPE", injectionKeyDescription="GetVariable.Injection.TRIMTYPE")
        private IValueMeta.TrimType trimType = IValueMeta.TrimType.NONE;

        public FieldDefinition() {
        }

        public FieldDefinition(FieldDefinition d) {
            this();
            this.fieldName = d.fieldName;
            this.variableString = d.variableString;
            this.fieldType = d.fieldType;
            this.fieldFormat = d.fieldFormat;
            this.fieldLength = d.fieldLength;
            this.fieldPrecision = d.fieldPrecision;
            this.currency = d.currency;
            this.decimal = d.decimal;
            this.group = d.group;
            this.trimType = d.trimType;
        }

        public int getHopType() {
            return ValueMetaFactory.getIdForValueMeta((String)this.fieldType);
        }

        public IValueMeta createValueMeta() throws HopPluginException {
            IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)this.fieldName, (int)this.getHopType());
            valueMeta.setLength(this.fieldLength, this.fieldPrecision);
            valueMeta.setConversionMask(this.fieldFormat);
            valueMeta.setDecimalSymbol(this.decimal);
            valueMeta.setGroupingSymbol(this.group);
            valueMeta.setCurrencySymbol(this.currency);
            valueMeta.setTrimType(this.trimType.getType());
            return valueMeta;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getVariableString() {
            return this.variableString;
        }

        public void setVariableString(String variableString) {
            this.variableString = variableString;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public String getFieldFormat() {
            return this.fieldFormat;
        }

        public void setFieldFormat(String fieldFormat) {
            this.fieldFormat = fieldFormat;
        }

        public int getFieldLength() {
            return this.fieldLength;
        }

        public void setFieldLength(int fieldLength) {
            this.fieldLength = fieldLength;
        }

        public int getFieldPrecision() {
            return this.fieldPrecision;
        }

        public void setFieldPrecision(int fieldPrecision) {
            this.fieldPrecision = fieldPrecision;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public String getDecimal() {
            return this.decimal;
        }

        public void setDecimal(String decimal) {
            this.decimal = decimal;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public IValueMeta.TrimType getTrimType() {
            return this.trimType;
        }

        public void setTrimType(IValueMeta.TrimType trimType) {
            this.trimType = trimType;
        }
    }

    public static final class IntTypeConverter
    implements IIntCodeConverter {
        public String getCode(int type) {
            return ValueMetaFactory.getValueMetaName((int)type);
        }

        public int getType(String code) {
            return ValueMetaFactory.getIdForValueMeta((String)code);
        }
    }
}

