/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.MoreStreams;
import autovalue.shaded.com.google.common.annotations.VisibleForTesting;
import autovalue.shaded.com.google.common.collect.ImmutableCollection;
import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import com.google.auto.value.processor.AutoValueishProcessor;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class BuilderRequiredProperties {
    static final BuilderRequiredProperties EMPTY = BuilderRequiredProperties.of(ImmutableSet.of(), ImmutableSet.of());
    final ImmutableSet<AutoValueishProcessor.Property> requiredProperties;
    final ImmutableMap<AutoValueishProcessor.Property, Integer> trackedPropertyToIndex;
    final ImmutableList<BitmaskField> bitmaskFields;

    static BuilderRequiredProperties of(ImmutableSet<AutoValueishProcessor.Property> allProperties, ImmutableSet<AutoValueishProcessor.Property> requiredProperties) {
        boolean hasDefaults = allProperties.stream().anyMatch(AutoValueishProcessor.Property::hasDefault);
        return hasDefaults ? new WithDefaults(allProperties, requiredProperties) : new NoDefaults(requiredProperties);
    }

    private BuilderRequiredProperties(ImmutableSet<AutoValueishProcessor.Property> requiredProperties, ImmutableList<AutoValueishProcessor.Property> trackedProperties) {
        this.requiredProperties = requiredProperties;
        int trackedCount = trackedProperties.size();
        this.trackedPropertyToIndex = IntStream.range(0, trackedCount).boxed().collect(MoreStreams.toImmutableMap(trackedProperties::get, i -> i));
        this.bitmaskFields = IntStream.range(0, (trackedCount + 31) / 32).mapToObj(i -> {
            int bitBase = i * 32;
            int remainingBits = trackedCount - bitBase;
            Class<?> type = BuilderRequiredProperties.classForBits(remainingBits);
            String name = "set$" + i;
            String allSetBitmask = remainingBits >= 32 ? "-1" : BuilderRequiredProperties.hex((1 << remainingBits) - 1);
            String allRequiredBitmask = this.allRequiredBitmask(trackedProperties, bitBase, remainingBits);
            return new BitmaskField(type, name, allSetBitmask, allRequiredBitmask);
        }).collect(MoreStreams.toImmutableList());
    }

    abstract String allRequiredBitmask(ImmutableList<AutoValueishProcessor.Property> var1, int var2, int var3);

    public ImmutableSet<AutoValueishProcessor.Property> getRequiredProperties() {
        return this.requiredProperties;
    }

    public ImmutableList<String> getFieldDeclarations() {
        return this.bitmaskFields.stream().map(field -> "private " + field.type + " " + field.name + ";").collect(MoreStreams.toImmutableList());
    }

    public ImmutableList<String> getInitToAllSet() {
        return this.bitmaskFields.stream().map(field -> field.name + " = " + BuilderRequiredProperties.cast(field.type, field.allSetBitmask) + ";").collect(MoreStreams.toImmutableList());
    }

    public String markAsSet(AutoValueishProcessor.Property p) {
        Integer index = this.trackedPropertyToIndex.get(p);
        if (index == null) {
            return "";
        }
        BitmaskField field = (BitmaskField)this.bitmaskFields.get(index / 32);
        return field.name + " |= " + BuilderRequiredProperties.cast(field.type, BuilderRequiredProperties.hex(1 << index)) + ";";
    }

    public String missingRequiredProperty(AutoValueishProcessor.Property p) {
        return this.requiredProperties.contains(p) ? this.propertyNotSet(p) : null;
    }

    public String noValueToGet(AutoValueishProcessor.Property p) {
        return this.requiredProperties.contains(p) || p.hasDefault() ? this.propertyNotSet(p) : null;
    }

    private String propertyNotSet(AutoValueishProcessor.Property p) {
        Integer index = this.trackedPropertyToIndex.get(p);
        if (index == null) {
            return "this." + p + " == null";
        }
        BitmaskField field = (BitmaskField)this.bitmaskFields.get(index / 32);
        return "(" + field.name + " & " + BuilderRequiredProperties.hex(1 << index) + ") == 0";
    }

    public abstract String getAnyMissing();

    public abstract String getDefaultedBitmaskParameters();

    private static Class<?> classForBits(int bits) {
        return bits <= 8 ? Byte.TYPE : (bits <= 16 ? Short.TYPE : Integer.TYPE);
    }

    private static String cast(Class<?> type, String number) {
        return type == Integer.TYPE ? number : "(" + type + ") " + number;
    }

    @VisibleForTesting
    static String hex(int number) {
        if (number >= 0) {
            if (number < 10) {
                return Integer.toHexString(number);
            }
            if (number <= 65535) {
                return "0x" + Integer.toHexString(number);
            }
        }
        String lowNybble = Integer.toHexString(number & 0xFFFF);
        String pad = "000".substring(lowNybble.length() - 1);
        return "0x" + Integer.toHexString(number >>> 16) + "_" + pad + lowNybble;
    }

    private static final class WithDefaults
    extends BuilderRequiredProperties {
        private final ImmutableList<AutoValueishProcessor.Property> allProperties;

        WithDefaults(ImmutableSet<AutoValueishProcessor.Property> allProperties, ImmutableSet<AutoValueishProcessor.Property> requiredProperties) {
            super(requiredProperties, allProperties.asList());
            this.allProperties = allProperties.asList();
        }

        @Override
        String allRequiredBitmask(ImmutableList<AutoValueishProcessor.Property> trackedProperties, int bitBase, int remainingBits) {
            int requiredBits = 0;
            for (int bit = 0; bit < remainingBits; ++bit) {
                AutoValueishProcessor.Property p = (AutoValueishProcessor.Property)trackedProperties.get(bitBase + bit);
                if (!this.requiredProperties.contains(p)) continue;
                requiredBits |= 1 << bit;
            }
            return WithDefaults.hex(requiredBits);
        }

        @Override
        public String getAnyMissing() {
            return this.bitmaskFields.stream().filter(field -> !field.allRequiredBitmask.equals("0")).map(field -> "(~" + field.name + " & " + field.allRequiredBitmask + ") != 0").collect(Collectors.joining("\n|| "));
        }

        @Override
        public String getDefaultedBitmaskParameters() {
            ImmutableList.Builder defaultedBitmasksBuilder = ImmutableList.builder();
            for (int bitBase = 0; bitBase < this.allProperties.size(); bitBase += 32) {
                int bitCount = Math.min(32, this.allProperties.size() - bitBase);
                int defaultedBitmask = 0;
                for (int i = 0; i < bitCount; ++i) {
                    if (!((AutoValueishProcessor.Property)this.allProperties.get(bitBase + i)).hasDefault()) continue;
                    defaultedBitmask |= 1 << i;
                }
                defaultedBitmasksBuilder.add((Object)defaultedBitmask);
            }
            ImmutableCollection defaultedBitmasks = defaultedBitmasksBuilder.build();
            return IntStream.range(0, this.bitmaskFields.size()).mapToObj(arg_0 -> this.lambda$getDefaultedBitmaskParameters$2((ImmutableList)defaultedBitmasks, arg_0)).collect(Collectors.joining(",\n", ",\n", ",\nnull"));
        }

        private /* synthetic */ String lambda$getDefaultedBitmaskParameters$2(ImmutableList defaultedBitmasks, int i) {
            int defaultedBitmask = (Integer)defaultedBitmasks.get(i);
            switch (defaultedBitmask) {
                case 0: {
                    return "0";
                }
                case -1: {
                    return "~" + ((BitmaskField)this.bitmaskFields.get((int)i)).name;
                }
            }
            return "~" + ((BitmaskField)this.bitmaskFields.get((int)i)).name + " & " + WithDefaults.hex(defaultedBitmask);
        }
    }

    private static final class NoDefaults
    extends BuilderRequiredProperties {
        NoDefaults(ImmutableSet<AutoValueishProcessor.Property> requiredProperties) {
            super(requiredProperties, NoDefaults.primitivePropertiesIn(requiredProperties));
        }

        private static ImmutableList<AutoValueishProcessor.Property> primitivePropertiesIn(ImmutableSet<AutoValueishProcessor.Property> properties) {
            return properties.stream().filter(p -> p.getKind().isPrimitive()).collect(MoreStreams.toImmutableList());
        }

        @Override
        String allRequiredBitmask(ImmutableList<AutoValueishProcessor.Property> trackedProperties, int bitBase, int remainingBits) {
            boolean minusOne = remainingBits >= 32 || remainingBits == 16 || remainingBits == 8;
            return minusOne ? "-1" : NoDefaults.hex((1 << remainingBits) - 1);
        }

        @Override
        public String getAnyMissing() {
            Stream<String> primitiveConditions = this.bitmaskFields.stream().map(field -> field.name + " != " + field.allRequiredBitmask);
            Stream<String> nonPrimitiveConditions = this.requiredProperties.stream().filter(p -> !this.trackedPropertyToIndex.containsKey(p)).map(this::missingRequiredProperty);
            return Stream.concat(primitiveConditions, nonPrimitiveConditions).collect(Collectors.joining("\n|| "));
        }

        @Override
        public String getDefaultedBitmaskParameters() {
            return "";
        }
    }

    private static class BitmaskField {
        final Class<?> type;
        final String name;
        final String allSetBitmask;
        final String allRequiredBitmask;

        BitmaskField(Class<?> type, String name, String allSetBitmask, String allRequiredBitmask) {
            this.type = type;
            this.name = name;
            this.allSetBitmask = allSetBitmask;
            this.allRequiredBitmask = allRequiredBitmask;
        }
    }
}

