/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.specialized;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlobLeaseClientBuilder;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.azure.storage.file.datalake.specialized.DataLakeLeaseAsyncClient;
import com.azure.storage.file.datalake.specialized.DataLakeLeaseClient;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={DataLakeLeaseClient.class, DataLakeLeaseAsyncClient.class})
public final class DataLakeLeaseClientBuilder {
    final BlobLeaseClientBuilder blobLeaseClientBuilder = new BlobLeaseClientBuilder();

    public DataLakeLeaseClient buildClient() {
        return new DataLakeLeaseClient(this.blobLeaseClientBuilder.buildClient());
    }

    public DataLakeLeaseAsyncClient buildAsyncClient() {
        return new DataLakeLeaseAsyncClient(this.blobLeaseClientBuilder.buildAsyncClient());
    }

    public DataLakeLeaseClientBuilder fileClient(DataLakeFileClient dataLakeFileClient) {
        Objects.requireNonNull(dataLakeFileClient);
        this.blobLeaseClientBuilder.blobClient((BlobClientBase)this.getSpecializedBlobClientBuilder(dataLakeFileClient.getFileUrl(), dataLakeFileClient.getHttpPipeline(), dataLakeFileClient.getServiceVersion()).buildBlockBlobClient());
        return this;
    }

    public DataLakeLeaseClientBuilder fileAsyncClient(DataLakeFileAsyncClient dataLakeFileAsyncClient) {
        Objects.requireNonNull(dataLakeFileAsyncClient);
        this.blobLeaseClientBuilder.blobAsyncClient((BlobAsyncClientBase)this.getSpecializedBlobClientBuilder(dataLakeFileAsyncClient.getFileUrl(), dataLakeFileAsyncClient.getHttpPipeline(), dataLakeFileAsyncClient.getServiceVersion()).buildBlockBlobAsyncClient());
        return this;
    }

    public DataLakeLeaseClientBuilder directoryClient(DataLakeDirectoryClient dataLakeDirectoryClient) {
        Objects.requireNonNull(dataLakeDirectoryClient);
        this.blobLeaseClientBuilder.blobClient((BlobClientBase)this.getSpecializedBlobClientBuilder(dataLakeDirectoryClient.getDirectoryUrl(), dataLakeDirectoryClient.getHttpPipeline(), dataLakeDirectoryClient.getServiceVersion()).buildBlockBlobClient());
        return this;
    }

    public DataLakeLeaseClientBuilder directoryAsyncClient(DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient) {
        Objects.requireNonNull(dataLakeDirectoryAsyncClient);
        this.blobLeaseClientBuilder.blobAsyncClient((BlobAsyncClientBase)this.getSpecializedBlobClientBuilder(dataLakeDirectoryAsyncClient.getDirectoryUrl(), dataLakeDirectoryAsyncClient.getHttpPipeline(), dataLakeDirectoryAsyncClient.getServiceVersion()).buildBlockBlobAsyncClient());
        return this;
    }

    public DataLakeLeaseClientBuilder fileSystemClient(DataLakeFileSystemClient dataLakeFileSystemClient) {
        Objects.requireNonNull(dataLakeFileSystemClient);
        this.blobLeaseClientBuilder.containerClient(this.getBlobContainerClientBuilder(dataLakeFileSystemClient.getFileSystemUrl(), dataLakeFileSystemClient.getHttpPipeline(), dataLakeFileSystemClient.getServiceVersion()).buildClient());
        return this;
    }

    public DataLakeLeaseClientBuilder fileSystemAsyncClient(DataLakeFileSystemAsyncClient dataLakeFileSystemAsyncClient) {
        Objects.requireNonNull(dataLakeFileSystemAsyncClient);
        this.blobLeaseClientBuilder.containerClient(this.getBlobContainerClientBuilder(dataLakeFileSystemAsyncClient.getFileSystemUrl(), dataLakeFileSystemAsyncClient.getHttpPipeline(), dataLakeFileSystemAsyncClient.getServiceVersion()).buildClient());
        return this;
    }

    public DataLakeLeaseClientBuilder leaseId(String leaseId) {
        this.blobLeaseClientBuilder.leaseId(leaseId);
        return this;
    }

    private SpecializedBlobClientBuilder getSpecializedBlobClientBuilder(String dfsEndpoint, HttpPipeline pipeline, DataLakeServiceVersion version) {
        String blobEndpoint = DataLakeImplUtils.endpointToDesiredEndpoint(dfsEndpoint, "blob", "dfs");
        return new SpecializedBlobClientBuilder().pipeline(pipeline).endpoint(blobEndpoint).serviceVersion(TransformUtils.toBlobServiceVersion(version));
    }

    private BlobContainerClientBuilder getBlobContainerClientBuilder(String dfsEndpoint, HttpPipeline pipeline, DataLakeServiceVersion version) {
        String blobEndpoint = DataLakeImplUtils.endpointToDesiredEndpoint(dfsEndpoint, "blob", "dfs");
        return new BlobContainerClientBuilder().pipeline(pipeline).endpoint(blobEndpoint).serviceVersion(TransformUtils.toBlobServiceVersion(version));
    }
}

