/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ginq.dsl.expression;

import java.util.Arrays;
import java.util.List;
import org.apache.groovy.ginq.dsl.GinqAstVisitor;
import org.apache.groovy.ginq.dsl.expression.DataSourceExpression;
import org.apache.groovy.ginq.dsl.expression.DataSourceHolder;
import org.apache.groovy.ginq.dsl.expression.GinqExpression;
import org.apache.groovy.ginq.dsl.expression.OnExpression;
import org.codehaus.groovy.ast.expr.Expression;

public class JoinExpression
extends DataSourceExpression
implements DataSourceHolder {
    public static final String SMART_INNER_JOIN = "join";
    public static final String INNER_JOIN = "innerjoin";
    public static final String INNER_HASH_JOIN = "innerhashjoin";
    private static final String LEFT_JOIN = "leftjoin";
    public static final String LEFT_HASH_JOIN = "lefthashjoin";
    private static final String CROSS_JOIN = "crossjoin";
    public static final List<String> JOIN_NAME_LIST = Arrays.asList("join", "innerjoin", "innerhashjoin", "leftjoin", "lefthashjoin", "rightjoin", "righthashjoin", "fulljoin", "fullhashjoin", "crossjoin");
    private final String joinName;
    private OnExpression onExpression;
    private DataSourceExpression dataSourceExpression;

    public JoinExpression(String joinName, Expression aliasExpr, Expression dataSourceExpr) {
        super(aliasExpr, dataSourceExpr);
        this.joinName = joinName;
    }

    public static boolean isJoinExpression(String methodName) {
        return JOIN_NAME_LIST.contains(methodName);
    }

    public boolean isCrossJoin() {
        return CROSS_JOIN.equals(this.joinName);
    }

    public boolean isSmartInnerJoin() {
        return SMART_INNER_JOIN.equals(this.joinName);
    }

    public boolean isInnerJoin() {
        return INNER_JOIN.equals(this.joinName);
    }

    public boolean isInnerHashJoin() {
        return INNER_HASH_JOIN.equals(this.joinName);
    }

    public boolean isLeftJoin() {
        return LEFT_JOIN.equals(this.joinName);
    }

    public boolean isLeftHashJoin() {
        return LEFT_HASH_JOIN.equals(this.joinName);
    }

    @Override
    public <R> R accept(GinqAstVisitor<R> visitor) {
        return visitor.visitJoinExpression(this);
    }

    public String getJoinName() {
        return this.joinName;
    }

    public OnExpression getOnExpression() {
        return this.onExpression;
    }

    public void setOnExpression(OnExpression onExpression) {
        this.onExpression = onExpression;
    }

    @Override
    public DataSourceExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    @Override
    public void setDataSourceExpression(DataSourceExpression dataSourceExpression) {
        this.dataSourceExpression = dataSourceExpression;
    }

    public String getText() {
        return this.joinName + " " + this.aliasExpr.getText() + " in " + (this.dataSourceExpr instanceof GinqExpression ? "(" + this.dataSourceExpr.getText() + ")" : this.dataSourceExpr.getText()) + (null == this.onExpression ? "" : " " + this.onExpression.getText());
    }

    public String toString() {
        return this.getText();
    }
}

