/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import java.beans.FeatureDescriptor;
import java.lang.reflect.Field;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.Entity;
import org.apache.empire.data.EntityDomain;
import org.apache.empire.data.RecordData;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBELResolver
extends ELResolver {
    private static final Logger log = LoggerFactory.getLogger(DBELResolver.class);

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            log.warn("DBELResolver:getCommonPropertyType is not implemented!");
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base instanceof Entity || base instanceof EntityDomain || base instanceof RecordData || base instanceof DBDatabase || base == null && property.equals("db")) {
            log.warn("DBELResolver:getType is not implemented!");
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        log.warn("DBELResolver:getFeatureDescriptors is not implemented!");
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base instanceof Entity) {
            String name = StringUtils.toString((Object)property);
            Column column = ((Entity)base).getColumn(name);
            if (column != null) {
                context.setPropertyResolved(true);
                return column;
            }
            Object propValue = this.getPropertyValue(base, name);
            if (propValue == null) {
                String entityName = base instanceof DBRowSet ? ((DBRowSet)base).getName() : base.getClass().getSimpleName();
                log.error("ELResolver error: Column '{}' cannot be resolved for entity/table/view '{}'.", (Object)name.toUpperCase(), (Object)entityName);
                return null;
            }
            if (propValue instanceof ColumnExpr) {
                context.setPropertyResolved(true);
                return propValue;
            }
            if (propValue instanceof ColumnExpr[]) {
                context.setPropertyResolved(true);
                return propValue;
            }
            log.error("ELResolver error: Field '{}.{}' is not a ColumnExpr.", (Object)base.getClass().getSimpleName(), property);
            return null;
        }
        if (base instanceof DBDatabase) {
            String name = StringUtils.toString((Object)property);
            DBRowSet rset = ((DBDatabase)base).getRowSet(name);
            if (rset == null) {
                rset = ((DBDatabase)base).getRowSetByAlias(name);
            }
            if (rset != null) {
                context.setPropertyResolved(true);
            } else {
                log.error("ELResolver error: Table/View '{}' cannot be resolved.", (Object)name.toUpperCase());
            }
            return rset;
        }
        if (base instanceof EntityDomain) {
            String name = StringUtils.toString((Object)property);
            Entity entity = ((EntityDomain)base).getEntity(name);
            if (entity != null) {
                context.setPropertyResolved(true);
            } else {
                log.error("ELResolver error: Entity '{}' cannot be resolved.", (Object)name.toUpperCase());
            }
            return entity;
        }
        if (base instanceof RecordData) {
            Object value;
            String field = StringUtils.toString((Object)property);
            if (field == null || field.length() == 0 || field.charAt(0) < 'A' || field.charAt(0) > 'Z') {
                return null;
            }
            int index = ((RecordData)base).getFieldIndex(field);
            if (index < 0) {
                log.warn("ELResolver warning: field '{}' not found in record .", (Object)field);
                return null;
            }
            ColumnExpr column = ((RecordData)base).getColumn(index);
            try {
                Class valueType = (Class)ObjectUtils.coalesce((Object)column.getEnumType(), Object.class);
                value = ((RecordData)base).getValue(index, valueType);
            }
            catch (FieldIllegalValueException e) {
                value = ((RecordData)base).getValue(index);
                log.error("The value \"{}\" for column {} could not be resolved.", value, (Object)column.getName());
            }
            context.setPropertyResolved(true);
            return value;
        }
        if (base == null) {
            String name = StringUtils.toString((Object)property);
            DBDatabase db = DBDatabase.findByIdentifier((String)name);
            if (db != null) {
                context.setPropertyResolved(true);
            }
            return db;
        }
        return null;
    }

    protected Object getPropertyValue(Object rowset, String property) {
        Class<?> c = rowset.getClass();
        try {
            Field f = c.getField(property);
            if (f == null) {
                return null;
            }
            Object v = f.get(rowset);
            if (v == null) {
                log.error("ELResolver error: Field '{}.{}' is null.", (Object)c.getSimpleName(), (Object)property);
                return null;
            }
            return v;
        }
        catch (SecurityException e) {
            log.error("ELResolver error: Unable to access field " + c.getSimpleName() + "." + property, (Throwable)e);
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            log.error("ELResolver error: Unable to access field " + c.getSimpleName() + "." + property, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error("ELResolver error: Unable to access field " + c.getSimpleName() + "." + property, (Throwable)e);
            return null;
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof Entity || base instanceof EntityDomain || base instanceof DBDatabase || base == null && property.equals("db")) {
            log.info("ELResolver: property {} is read only.", property);
            return true;
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (this.isReadOnly(context, base, property)) {
            NotSupportedException e = new NotSupportedException((Object)this, "setValue");
            FacesContext.getCurrentInstance().getExternalContext().log(e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

