/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.compress.utils.BitInputStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BitInputStreamTest {
    BitInputStreamTest() {
    }

    private ByteArrayInputStream getStream() {
        return new ByteArrayInputStream(new byte[]{-8, 64, 1, 47});
    }

    @Test
    void testAlignWithByteBoundaryWhenAtBoundary() throws Exception {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((long)248L, (long)bis.readBits(8));
            bis.alignWithByteBoundary();
            Assertions.assertEquals((long)0L, (long)bis.readBits(4));
        }
    }

    @Test
    void testAlignWithByteBoundaryWhenNotAtBoundary() throws Exception {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((long)8L, (long)bis.readBits(4));
            Assertions.assertEquals((int)4, (int)bis.bitsCached());
            bis.alignWithByteBoundary();
            Assertions.assertEquals((int)0, (int)bis.bitsCached());
            Assertions.assertEquals((long)0L, (long)bis.readBits(4));
        }
    }

    @Test
    void testAvailableWithCache() throws Exception {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((long)8L, (long)bis.readBits(4));
            Assertions.assertEquals((long)28L, (long)bis.bitsAvailable());
        }
    }

    @Test
    void testAvailableWithoutCache() throws Exception {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((long)32L, (long)bis.bitsAvailable());
        }
    }

    @Test
    void testBigEndianWithOverflow() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{87, 45, 66, 15, 90, 29, 88, 61, 33, 74});
        try (BitInputStream bin = new BitInputStream((InputStream)in, ByteOrder.BIG_ENDIAN);){
            Assertions.assertEquals((long)10L, (long)bin.readBits(5));
            Assertions.assertEquals((long)8274274654740644818L, (long)bin.readBits(63));
            Assertions.assertEquals((long)330L, (long)bin.readBits(12));
            Assertions.assertEquals((long)-1L, (long)bin.readBits(1));
        }
    }

    @Test
    void testClearBitCache() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((long)8L, (long)bis.readBits(4));
            bis.clearBitCache();
            Assertions.assertEquals((long)0L, (long)bis.readBits(1));
        }
    }

    @Test
    void testEOF() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((long)788611320L, (long)bis.readBits(30));
            Assertions.assertEquals((long)-1L, (long)bis.readBits(3));
        }
    }

    @Test
    void testLittleEndianWithOverflow() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{87, 45, 66, 15, 90, 29, 88, 61, 33, 74});
        try (BitInputStream bin = new BitInputStream((InputStream)in, ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((long)23L, (long)bin.readBits(5));
            Assertions.assertEquals((long)714595605644185962L, (long)bin.readBits(63));
            Assertions.assertEquals((long)1186L, (long)bin.readBits(12));
            Assertions.assertEquals((long)-1L, (long)bin.readBits(1));
        }
    }

    @Test
    void testReading17BitsInBigEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.BIG_ENDIAN);){
            Assertions.assertEquals((long)127104L, (long)bis.readBits(17));
        }
    }

    @Test
    void testReading17BitsInLittleEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((long)82168L, (long)bis.readBits(17));
        }
    }

    @Test
    void testReading24BitsInBigEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.BIG_ENDIAN);){
            Assertions.assertEquals((long)16269313L, (long)bis.readBits(24));
        }
    }

    @Test
    void testReading24BitsInLittleEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((long)82168L, (long)bis.readBits(24));
        }
    }

    @Test
    void testReading30BitsInBigEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.BIG_ENDIAN);){
            Assertions.assertEquals((long)1041236043L, (long)bis.readBits(30));
        }
    }

    @Test
    void testReading30BitsInLittleEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((long)788611320L, (long)bis.readBits(30));
        }
    }

    @Test
    void testReading31BitsInBigEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.BIG_ENDIAN);){
            Assertions.assertEquals((long)2082472087L, (long)bis.readBits(31));
        }
    }

    @Test
    void testReading31BitsInLittleEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((long)788611320L, (long)bis.readBits(31));
        }
    }

    @Test
    void testReadingOneBitFromEmptyStream() throws Exception {
        try (BitInputStream bis = new BitInputStream((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((int)-1, (int)bis.readBit(), (String)"next bit");
            Assertions.assertEquals((int)-1, (int)bis.readBit(), (String)"next bit");
            Assertions.assertEquals((int)-1, (int)bis.readBit(), (String)"next bit");
        }
    }

    @Test
    void testReadingOneBitInBigEndian() throws Exception {
        try (BitInputStream bis = new BitInputStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 3}), ByteOrder.BIG_ENDIAN);){
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 0");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 1");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 2");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 3");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 4");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 5");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 6");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 7");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 8");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 9");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 10");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 11");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 12");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 13");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 14");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 15");
            Assertions.assertEquals((int)-1, (int)bis.readBit(), (String)"next bit");
        }
    }

    @Test
    void testReadingOneBitInLittleEndian() throws Exception {
        try (BitInputStream bis = new BitInputStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 3}), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 0");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 1");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 2");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 3");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 4");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 5");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 6");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 7");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 8");
            Assertions.assertEquals((int)1, (int)bis.readBit(), (String)"bit 9");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 10");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 11");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 12");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 13");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 14");
            Assertions.assertEquals((int)0, (int)bis.readBit(), (String)"bit 15");
            Assertions.assertEquals((int)-1, (int)bis.readBit(), (String)"next bit");
        }
    }

    @Test
    void testShouldNotAllowReadingOfANegativeAmountOfBits() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertThrows(IOException.class, () -> bis.readBits(-1));
        }
    }

    @Test
    void testShouldNotAllowReadingOfMoreThan63BitsAtATime() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assertions.assertThrows(IOException.class, () -> bis.readBits(64));
        }
    }
}

