/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.resolver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.wsdl.xml.WSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.woden.WSDLException;
import org.apache.woden.resolver.URIResolver;
import org.apache.ws.commons.schema.resolver.DefaultURIResolver;
import org.xml.sax.InputSource;

public class AARBasedWSDLLocator
extends DefaultURIResolver
implements WSDLLocator,
URIResolver {
    protected static final Log log = LogFactory.getLog(AARBasedWSDLLocator.class);
    private File aarFile;
    private InputStream baseInputStream;
    private URI lastImportLocation;
    private String baseURI;

    public AARBasedWSDLLocator(String baseURI, File zipFile, InputStream baseInputStream) {
        this.baseURI = baseURI;
        this.baseInputStream = baseInputStream;
        this.aarFile = zipFile;
    }

    public InputSource getBaseInputSource() {
        return new InputSource(this.baseInputStream);
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        this.lastImportLocation = URI.create(parentLocation).resolve(importLocation);
        if (this.isAbsolute(this.lastImportLocation.toString())) {
            return super.resolveEntity(null, importLocation, parentLocation);
        }
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(new FileInputStream(this.aarFile));
            byte[] buf = new byte[1024];
            String searchingStr = this.lastImportLocation.toString();
            while ((entry = zin.getNextEntry()) != null) {
                int read;
                String entryName = entry.getName().toLowerCase();
                if (!entryName.equalsIgnoreCase(searchingStr)) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((read = zin.read(buf)) > 0) {
                    out.write(buf, 0, read);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                InputSource inputSource = new InputSource(in);
                return inputSource;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
        }
        log.info((Object)("AARBasedWSDLLocator: Unable to resolve " + String.valueOf(this.lastImportLocation)));
        return null;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getLatestImportURI() {
        return this.lastImportLocation.toString();
    }

    public void close() {
    }

    public URI resolveURI(URI uri) throws WSDLException, IOException {
        this.lastImportLocation = URI.create(this.baseURI).resolve(uri);
        if (this.isAbsolute(uri.toString())) {
            return uri;
        }
        String absolutePath = this.aarFile.getAbsolutePath();
        try {
            return new URI("jar:file://" + absolutePath + "!/" + String.valueOf(this.lastImportLocation));
        }
        catch (URISyntaxException e) {
            log.debug((Object)e);
            log.info((Object)("AARBasedWSDLLocator: Unable to resolve " + String.valueOf(this.lastImportLocation)));
            return null;
        }
    }

    protected boolean isAbsolute(String uri) {
        String[] protocols = new String[]{"http://", "https://", "file:/", "jar:"};
        for (int i = 0; i < protocols.length; ++i) {
            if (!uri.startsWith(protocols[i])) continue;
            return true;
        }
        return false;
    }
}

