/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.state;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.clustering.state.commands.DeleteServiceGroupStateCommand;
import org.apache.axis2.clustering.state.commands.StateClusteringCommandCollection;
import org.apache.axis2.clustering.state.commands.UpdateConfigurationStateCommand;
import org.apache.axis2.clustering.state.commands.UpdateServiceGroupStateCommand;
import org.apache.axis2.clustering.state.commands.UpdateServiceStateCommand;
import org.apache.axis2.clustering.state.commands.UpdateStateCommand;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.PropertyDifference;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StateClusteringCommandFactory {
    private static final Log log = LogFactory.getLog(StateClusteringCommandFactory.class);

    public static StateClusteringCommandCollection getCommandCollection(AbstractContext[] contexts, Map excludedReplicationPatterns) {
        ArrayList<StateClusteringCommand> commands = new ArrayList<StateClusteringCommand>(contexts.length);
        StateClusteringCommandCollection collection = new StateClusteringCommandCollection(commands);
        for (AbstractContext context : contexts) {
            StateClusteringCommand cmd = StateClusteringCommandFactory.getUpdateCommand(context, excludedReplicationPatterns, false);
            if (cmd == null) continue;
            commands.add(cmd);
        }
        return collection;
    }

    public static StateClusteringCommand getUpdateCommand(AbstractContext context, Map excludedPropertyPatterns, boolean includeAllProperties) {
        UpdateStateCommand cmd = StateClusteringCommandFactory.toUpdateContextCommand(context);
        if (cmd != null) {
            StateClusteringCommandFactory.fillProperties(cmd, context, excludedPropertyPatterns, includeAllProperties);
            if (cmd.isPropertiesEmpty()) {
                cmd = null;
            }
        }
        return cmd;
    }

    public static StateClusteringCommand getUpdateCommand(AbstractContext context, String[] propertyNames) throws ClusteringFault {
        UpdateStateCommand cmd = StateClusteringCommandFactory.toUpdateContextCommand(context);
        if (cmd != null) {
            StateClusteringCommandFactory.fillProperties(cmd, context, propertyNames);
            if (cmd.isPropertiesEmpty()) {
                cmd = null;
            }
        }
        return cmd;
    }

    private static UpdateStateCommand toUpdateContextCommand(AbstractContext context) {
        UpdateStateCommand cmd = null;
        if (context instanceof ConfigurationContext) {
            cmd = new UpdateConfigurationStateCommand();
        } else if (context instanceof ServiceGroupContext) {
            ServiceGroupContext sgCtx = (ServiceGroupContext)context;
            cmd = new UpdateServiceGroupStateCommand();
            UpdateServiceGroupStateCommand updateSgCmd = (UpdateServiceGroupStateCommand)cmd;
            updateSgCmd.setServiceGroupName(sgCtx.getDescription().getServiceGroupName());
            updateSgCmd.setServiceGroupContextId(sgCtx.getId());
        } else if (context instanceof ServiceContext) {
            ServiceContext serviceCtx = (ServiceContext)context;
            cmd = new UpdateServiceStateCommand();
            UpdateServiceStateCommand updateServiceCmd = (UpdateServiceStateCommand)cmd;
            String sgName = serviceCtx.getServiceGroupContext().getDescription().getServiceGroupName();
            updateServiceCmd.setServiceGroupName(sgName);
            updateServiceCmd.setServiceGroupContextId(serviceCtx.getServiceGroupContext().getId());
            updateServiceCmd.setServiceName(serviceCtx.getAxisService().getName());
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillProperties(UpdateStateCommand updateCmd, AbstractContext context, Map excludedPropertyPatterns, boolean includeAllProperties) {
        if (!includeAllProperties) {
            AbstractContext abstractContext = context;
            synchronized (abstractContext) {
                Map diffs = context.getPropertyDifferences();
                for (Object o : diffs.keySet()) {
                    String key = (String)o;
                    PropertyDifference diff = (PropertyDifference)diffs.get(key);
                    Object value = diff.getValue();
                    if (!StateClusteringCommandFactory.isSerializable(value) || StateClusteringCommandFactory.isExcluded(key, context.getClass().getName(), excludedPropertyPatterns)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("sending property =" + key + "-" + String.valueOf(value)));
                    }
                    updateCmd.addProperty(diff);
                }
            }
        }
        AbstractContext abstractContext = context;
        synchronized (abstractContext) {
            Iterator iter = context.getPropertyNames();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = context.getPropertyNonReplicable(key);
                if (!StateClusteringCommandFactory.isSerializable(value) || StateClusteringCommandFactory.isExcluded(key, context.getClass().getName(), excludedPropertyPatterns)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sending property =" + key + "-" + String.valueOf(value)));
                }
                PropertyDifference diff = new PropertyDifference(key, value, false);
                updateCmd.addProperty(diff);
            }
        }
    }

    private static void fillProperties(UpdateStateCommand updateCmd, AbstractContext context, String[] propertyNames) throws ClusteringFault {
        Map diffs = context.getPropertyDifferences();
        for (String key : propertyNames) {
            Object prop = context.getPropertyNonReplicable(key);
            if (StateClusteringCommandFactory.isSerializable(prop)) {
                PropertyDifference diff;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sending property =" + key + "-" + String.valueOf(prop)));
                }
                if ((diff = (PropertyDifference)diffs.get(key)) == null) continue;
                diff.setValue(prop);
                updateCmd.addProperty(diff);
                diffs.remove(key);
                continue;
            }
            String msg = "Trying to replicate non-serializable property " + key + " in context " + String.valueOf(context);
            throw new ClusteringFault(msg);
        }
    }

    private static boolean isExcluded(String propertyName, String ctxClassName, Map excludedPropertyPatterns) {
        List defaultExcludes;
        List specificExcludes = (List)excludedPropertyPatterns.get(ctxClassName);
        boolean isExcluded = false;
        if (specificExcludes != null) {
            isExcluded = StateClusteringCommandFactory.isExcluded(specificExcludes, propertyName);
        }
        if (!isExcluded && (defaultExcludes = (List)excludedPropertyPatterns.get("defaults")) != null) {
            isExcluded = StateClusteringCommandFactory.isExcluded(defaultExcludes, propertyName);
        }
        return isExcluded;
    }

    private static boolean isExcluded(List list, String propertyName) {
        for (Object aList : list) {
            String pattern = (String)aList;
            if (!(pattern.startsWith("*") ? propertyName.endsWith(pattern = pattern.replaceAll("\\*", "")) : (pattern.endsWith("*") ? propertyName.startsWith(pattern = pattern.replaceAll("\\*", "")) : pattern.equals(propertyName)))) continue;
            return true;
        }
        return false;
    }

    public static StateClusteringCommand getRemoveCommand(AbstractContext abstractContext) {
        if (abstractContext instanceof ServiceGroupContext) {
            ServiceGroupContext sgCtx = (ServiceGroupContext)abstractContext;
            DeleteServiceGroupStateCommand cmd = new DeleteServiceGroupStateCommand();
            cmd.setServiceGroupContextId(sgCtx.getId());
            return cmd;
        }
        return null;
    }

    private static boolean isSerializable(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(obj);
            oos.close();
            return out.toByteArray().length > 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

